package com.sonicsw.mf.common.config.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

import com.sonicsw.security.ssl.CipherSuiteUtil;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;

public class TypedConfigUpgrade76 implements IVersionedConfigUpgrade, IMigrationProcess 
{
	private UpgradeEnv m_upgradeEnv = null;

	@Override
    public String basicConfigUpgrade(IDirElement el, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

    @Override
    public String getUpgradedReleaseVersion() 
	{
		return "104";
	}

	@Override
    public String upgradeMF_ACTIVATION_DAEMON(IDirElement daemon, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeMF_AGENT_MANAGER(IDirElement agentManager,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeMF_COLLECTION_MONITOR(IDirElement monitor,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

    @Override
    public String upgradeMF_HOST_MANAGER(IDirElement hostmanager, UpgradeEnv env) throws Exception
    {
        return null;
    }

    @Override
    public String upgradeMF_CONTAINER(IDirElement container, UpgradeEnv env)
			throws Exception 
	{
		IAttributeSet topSet = container.getAttributes();
		String containerName = (String)topSet.getAttribute("CONTAINER_NAME");
		IAttributeSet newEnabledMetrics = (IAttributeSet)topSet.getAttribute("ENABLED_METRICS");
		IAttributeSet newCentralConnection = (IAttributeSet)topSet.getAttribute("CENTRAL_CONNECTION");
        IAttributeMetaData metaData = topSet.getAttributeMetaData("WORKING_DIRECTORY");
        if ((metaData == null) || !metaData.isFromTemplate() &&
            (topSet.getAttribute("WORKING_DIRECTORY") != null))
        {
            topSet.deleteAttribute("WORKING_DIRECTORY");
        }
        // move the AGENTs runtime metrics and alerts to the container configuration
        // /_MFRuntime/Domain1.DomainManager/AGENT/alerts"
        // "/_MFRuntime/Domain1.DomainManager/AGENT/metrics"
        // Do one pass and collect all metrics and alerts set for this container and
        // its components
        String containerCanonicalName = env.getProp(DOMAINPROP) + "." + topSet.getAttribute("CONTAINER_NAME");
        String containerMetricsDir = "/_MFRuntime/" + containerCanonicalName;
        IDirIdentity[] directories = null;
        try
        {
        	directories = env.dsAdmin.listDirectories(containerMetricsDir);
        }
        catch (DirectoryDoesNotExistException notThere )
        {
        	// nothing to do
        	return null;
        }
        HashMap metricsAndAlerts = new HashMap();
        
        for (int i=0; i< directories.length; i++)
        {
        	IDirIdentity dirID = directories[i];
        	String component = dirID.getName().substring(dirID.getName().lastIndexOf(IMFDirectories.MF_DIR_SEPARATOR) + 1);
        	HashMap compMetricsAndAlerts = new HashMap();
        	IDirElement[] compSettings = env.dsAdmin.getAllElements(dirID.getName(), true);
        	// should only be one alert and one metrics element per component
        	
        	for (int j=0; j< 2; j++)
        	{
        		if (compSettings.length > j)
        		{
        		    IDirElement indivMetricOrAlerts = compSettings[j];
        		    IAttributeSet indivTop = indivMetricOrAlerts.getAttributes();
        		    HashMap topMap = indivTop.getAttributes();
        		    Set topMapKeys = topMap.keySet();
        		    Iterator topMapKeysIt = topMapKeys.iterator();
        		    while (topMapKeysIt.hasNext())
        		    {
        			    String metricOrAlertName = (String)topMapKeysIt.next();
        			    IAttributeSet metricOrAlertSet = (IAttributeSet)indivTop.getAttribute(metricOrAlertName);
        			    HashMap alertSettings = metricOrAlertSet.getAttributes();
        			    HashMap collectedMetricsAndAlerts = (HashMap)compMetricsAndAlerts.get(metricOrAlertName);
        			    if (collectedMetricsAndAlerts == null)
                        {
                            collectedMetricsAndAlerts = new HashMap();
                        }
        			    if (!alertSettings.isEmpty()) // and alert set with alert settings
        			    {
        				    IAttributeList high = (IAttributeList)alertSettings.get("highThresholds");
        				    if (high != null && high.getCount() > 0)
        				    {
        					    ArrayList highItems = high.getItems();
        					    ArrayList colItems = new ArrayList();
        					    Iterator highIT = highItems.iterator();
        					    while (highIT.hasNext())
        					    {
        						    long value = ((Long)highIT.next()).longValue();  
        						    colItems.add(value);
        					    }
        					    collectedMetricsAndAlerts.put("highThresholds", colItems);
        				    }
        				    IAttributeList low = (IAttributeList)alertSettings.get("lowThresholds");
        				    if (low != null && low.getCount() > 0)
        				    {
        					    ArrayList lowItems = low.getItems();
        					    ArrayList colItems = new ArrayList();
        					    Iterator lowIT = lowItems.iterator();
        					    while (lowIT.hasNext())
        					    {
        						    long value = ((Long)lowIT.next()).longValue();  
        						    colItems.add(value);
        					    }
        					    collectedMetricsAndAlerts.put("lowThresholds", colItems);
        				    }
        			    }
        			    compMetricsAndAlerts.put(metricOrAlertName, collectedMetricsAndAlerts);
        		    }
        		}       					
        	}
        	metricsAndAlerts.put(component, compMetricsAndAlerts);        	
        }
        // now that we have the  values in a condensed format, migrate them to the container
        // configuration
        Iterator componentNames = metricsAndAlerts.keySet().iterator();
        IAttributeSet components = (IAttributeSet)topSet.getAttribute("COMPONENTS");
        while (componentNames.hasNext())
        {
        	String componentName = (String)componentNames.next();
        	HashMap compMetrics = (HashMap)metricsAndAlerts.get(componentName);
        	if (componentName.equals("AGENT"))
        	{       
                if (compMetrics != null && newEnabledMetrics == null)
                {
                    newEnabledMetrics = topSet.createAttributeSet("ENABLED_METRICS");
                }
                transferMetrics(compMetrics, newEnabledMetrics);
        	}
        	else
        	{
        		IAttributeSet compSet = (IAttributeSet)components.getAttribute(componentName);
        		IAttributeSet enabledMetricsSet;
        		// if there's more than one container with the same name in
        		// different folders, the component named in the metrics and alert
        		// runtime elements might not be in this particular container, so
        		// the component is not found and compSet == null
        		if (compMetrics != null && compSet != null)
        		{
        			enabledMetricsSet = compSet.createAttributeSet("ENABLED_METRICS");
        			transferMetrics(compMetrics, enabledMetricsSet);
        		}
        	}
        }
        
        
        // CENTRAL_CONNECTION
        String centralProp = (String)env.getContainerProp(containerName, CENTRALURLPROP);
        if (centralProp != null)
        {
        	if (newCentralConnection == null)
            {
                newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
            }
        	newCentralConnection.setStringAttribute("ConnectionURLs", centralProp);
        }
        centralProp = (String)env.getContainerProp(containerName, CENTRALUSERPROP);
        if (centralProp != null)
        {
        	if (newCentralConnection == null)
            {
                newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
            }
        	newCentralConnection.setStringAttribute("DefaultUser", centralProp);
        }
        centralProp = (String)env.getContainerProp(containerName, CENTRALPWPROP);
        if (centralProp != null)
        {
        	if (newCentralConnection == null)
            {
                newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
            }
        	newCentralConnection.setStringAttribute("DefaultPassword", centralProp);
        }
        centralProp = (String)env.getContainerProp(containerName, CENTRALRTPROP);
        if (centralProp != null)
        {
        	if (newCentralConnection == null)
            {
                newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
            }
        	newCentralConnection.setIntegerAttribute("REQUEST_TIMEOUT", new Integer(centralProp));
        }
        centralProp = (String)env.getContainerProp(containerName, CENTRALCTPROP);
        if (centralProp != null)
        {
        	if (newCentralConnection == null)
            {
                newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
            }
        	newCentralConnection.setIntegerAttribute("CONNECT_TIMEOUT", new Integer(centralProp));
        }
        centralProp = (String)env.getContainerProp(containerName, CENTRALSCPROP);
        if (centralProp != null)
        {
        	if (newCentralConnection == null)
            {
                newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
            }
        	newCentralConnection.setIntegerAttribute("SOCKET_CONNECT_TIMEOUT", new Integer(centralProp));
        }
        centralProp = (String)env.getContainerProp(containerName, CENTRALLBPROP);
        if (centralProp != null)
        {
        	if (newCentralConnection == null)
            {
                newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
            }
        	newCentralConnection.setBooleanAttribute("LoadBalancing", new Boolean(centralProp));
        }
        centralProp = (String)env.getContainerProp(containerName, CENTRALCONNPROPSPROP);
        if (centralProp != null)
        {
        	IAttributeSet sysProps = (IAttributeSet)topSet.getAttribute("SYSTEM_PROPERTIES");
        	if (sysProps == null)
            {
                sysProps = topSet.createAttributeSet("SYSTEM_PROPERTIES");
            }
        	StringTokenizer propsTokenizer = new StringTokenizer(centralProp, ",=", false);
        	while (propsTokenizer.hasMoreTokens())
        	{
        		String prop = propsTokenizer.nextToken();
        		String value = propsTokenizer.nextToken();
        		sysProps.setStringAttribute(prop, value);
        	}
        	
        }
    
        return null;
	}

	@Override
    public String upgradeMF_DIRECTORY_SERVICE(IDirElement dsElement,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
    public String upgradeMF_BACKUP_DIRECTORY_SERVICE(IDirElement dsElement,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeMF_LOGGER(IDirElement logger, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeMQ_BROKER(IDirElement broker, UpgradeEnv env)
			throws Exception 
	{
		m_upgradeEnv = env;
		IAttributeSet topSet = broker.getAttributes();
		
		// remove external database attributes
		IAttributeSet dbSet = (IAttributeSet)topSet.getAttribute("BROKER_DATABASE_PARAMETERS");
		IAttributeMetaData metaData = topSet.getAttributeMetaData("BROKER_DATABASE_PARAMETERS");
		if ((metaData == null) || !metaData.isFromTemplate() &&
	            (dbSet != null))
		{
			String jdbcDriver = (String)dbSet.getAttribute("JDBC_DRIVER");
			metaData = topSet.getAttributeMetaData("JDBC_DRIVER");
			if ((metaData == null) || !metaData.isFromTemplate() &&
		            (jdbcDriver != null))
            {
                dbSet.deleteAttribute("JDBC_DRIVER");
            }
			String dbUser = (String)dbSet.getAttribute("DB_USER");
			metaData = topSet.getAttributeMetaData("DB_USER");
			if ((metaData == null) || !metaData.isFromTemplate() &&
		            (dbUser != null))
            {
                dbSet.deleteAttribute("DB_USER");
            }
			String dbPwd = (String)dbSet.getAttribute("DB_PASSWORD");
			metaData = topSet.getAttributeMetaData("DB_PASSWORD");
			if ((metaData == null) || !metaData.isFromTemplate() &&
		            (dbPwd != null))
            {
                dbSet.deleteAttribute("DB_PASSWORD");
            }
			String dbConnect = (String)dbSet.getAttribute("DB_CONNECT");
			metaData = topSet.getAttributeMetaData("DB_CONNECT");
			if ((metaData == null) || !metaData.isFromTemplate() &&
		            (dbConnect != null))
            {
                dbSet.deleteAttribute("DB_CONNECT");
            }
			String dbProps= (String)dbSet.getAttribute("DB_PROPERTIES");
			metaData = topSet.getAttributeMetaData("DB_PROPERTIES");
			if ((metaData == null) || !metaData.isFromTemplate() &&
		            (dbProps != null))
            {
                dbSet.deleteAttribute("DB_PROPERTIES");
            }
			String dbCheck= (String)dbSet.getAttribute("DB_CHECK_INTERVAL");
			metaData = topSet.getAttributeMetaData("DB_CHECK_INTERVAL");
			if ((metaData == null) || !metaData.isFromTemplate() &&
		            (dbCheck != null))
            {
                dbSet.deleteAttribute("DB_CHECK_INTERVAL");
            }
		}
		// migrate RSA to JSSE
		
		migrateToJSSE(topSet, broker.getIdentity().getType());
		
		return null;
	}
	
	// topSet is the top attribute set of the broker element
	private void migrateToJSSE(IAttributeSet topSet, String brokerType) throws ReadOnlyException, AttributeSetTypeException, ConfigException
	{
		IAttributeSet sslSet = (IAttributeSet)topSet.getAttribute("BROKER_SSL_PARAMETERS");
		IAttributeMetaData sslMetaData = topSet.getAttributeMetaData("BROKER_SSL_PARAMETERS");
		if (sslSet != null)
		{
			IAttributeSet CRLSet = (IAttributeSet)sslSet.getAttribute("CA_LIST");
			if (CRLSet != null)
			{
				HashMap values = CRLSet.getAttributes();
				if (!values.isEmpty())
                 {
                    return; // no upgrade, they remain with RSA
                }
			}
		}
		if (((sslMetaData == null) || !sslMetaData.isFromTemplate()) &&
            (sslSet != null))
		{
			IAttributeMetaData providerClassMD = sslSet.getAttributeMetaData("SSL_PROVIDER_CLASS");
			if (brokerType.equals("MQ_BROKER") && (providerClassMD == null || !providerClassMD.isFromTemplate()))
            {
                sslSet.setStringAttribute("SSL_PROVIDER_CLASS", "progress.message.net.ssl.jsse.jsseSSLImpl");
            }
		    String ciphersSet = (String)sslSet.getAttribute("SSL_CIPHER_SUITES");
		    IAttributeMetaData cipherMeta = sslSet.getAttributeMetaData("SSL_CIPHER_SUITES");
		    if ((cipherMeta == null || !cipherMeta.isFromTemplate()) && ciphersSet != null)
		    {
		    	if (m_upgradeEnv.isDEBUG())
                {
                    System.out.println("TypesConfigUpgrade76.migrateToJSSE original ciphers " + ciphersSet);
                }
		    	String newCiphers = "";
		    	StringTokenizer parseIt = new StringTokenizer(ciphersSet, ",", false);
		    	while (parseIt.hasMoreTokens())
		    	{
		    		String cipher = parseIt.nextToken();
		    		String substitute = CipherSuiteUtil.getJSSECipherSuiteFromRSA(cipher);
		    		if (substitute == null)
                    {
                        newCiphers = newCiphers + cipher;
                    }
                    else
                    {
                        newCiphers = newCiphers + substitute;
                    }
		    		if (parseIt.hasMoreTokens())
                    {
                        newCiphers = newCiphers + ",";
                    }
		    	}
		    	if (m_upgradeEnv.isDEBUG())
                {
                    System.out.println("TypesConfigUpgrade76.migrateToJSSE new ciphers " + newCiphers);
                }
		    	sslSet.setStringAttribute("SSL_CIPHER_SUITES", newCiphers);
		    }		
		}
	}
	
	private void transferMetrics(HashMap compMetrics, IAttributeSet newEnabledMetrics) throws ReadOnlyException, AttributeSetTypeException, ConfigException
	{
		Set agentMetricNames = compMetrics.keySet();
        Iterator agentMetricIT = agentMetricNames.iterator();
        while (agentMetricIT.hasNext())
        {
	        String metric = (String)agentMetricIT.next();
	        IAttributeSet newMetricSet = newEnabledMetrics.createAttributeSet(metric);
	        HashMap thresholds = (HashMap)compMetrics.get(metric);
	        Iterator thresholdITs = thresholds.keySet().iterator();
	        while (thresholdITs.hasNext())
	        {
		        String lowOrHigh = (String)thresholdITs.next();
		        ArrayList value = (ArrayList)thresholds.get(lowOrHigh);
		    // there's only one value
		        if (lowOrHigh.equals("highThresholds"))
                {
                    newMetricSet.setStringAttribute("HIGH_THRESHOLDS", ((Long)value.get(0)).toString());
                }
                else if (lowOrHigh.equals("lowThresholds"))
                {
                    newMetricSet.setStringAttribute("LOW_THRESHOLDS", ((Long)value.get(0)).toString());
                }
	        }
        }
	}

	@Override
    public String upgradeMQ_CLUSTER(IDirElement cluster, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeXQ_CONTAINER(IDirElement xqContainer, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

}
