package com.sonicsw.mf.common.config.upgrade;

import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerConstants;

public class TypedConfigUpgrade80 implements IVersionedConfigUpgrade,
		IMigrationProcess 
{
	private UpgradeEnv m_upgradeEnv = null;
	private HashMap<String,Boolean> m_ftdValues = new HashMap<String, Boolean>();

	@Override
    public String basicConfigUpgrade(IDirElement el, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

    @Override
    public String getUpgradedReleaseVersion() 
	{
		return "105";
	}

	@Override
    public String upgradeMF_ACTIVATION_DAEMON(IDirElement daemon, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeMF_AGENT_MANAGER(IDirElement agentManager,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeMF_BACKUP_DIRECTORY_SERVICE(IDirElement backupElement,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public String upgradeMF_COLLECTION_MONITOR(IDirElement monitor,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}

    @Override
    public String upgradeMF_HOST_MANAGER(IDirElement hostmanager, UpgradeEnv env) throws Exception
    {
        return null;
    }

    @Override
    public String upgradeMF_CONTAINER(IDirElement container, UpgradeEnv env)
			throws Exception 
	{
		// upgrade metrics
	    upgradeContainerMetrics(container, env);
	    upgradeComponentMetrics(container, env);
		return null;
	}

	@Override
    public String upgradeMF_DIRECTORY_SERVICE(IDirElement dsElement,
			UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
    public String upgradeMF_LOGGER(IDirElement logger, UpgradeEnv env)
			throws Exception 
	{
		m_upgradeEnv = env;
		IAttributeSet topSet = logger.getAttributes();
		IAttributeSet product_information = (IAttributeSet)topSet.getAttribute("PRODUCT_INFORMATION");
		IAttributeMetaData pi_metadata = topSet.getAttributeMetaData("PRODUCT_INFORMATION");
		if (((pi_metadata == null) || !pi_metadata.isFromTemplate()) && 
		    (product_information != null))
        {
            topSet.deleteAttribute("PRODUCT_INFORMATION");
        }
		return null;
	}


	@Override
    public String upgradeMQ_BROKER(IDirElement broker, UpgradeEnv env)
			throws Exception 
	{
		m_upgradeEnv = env;
		// remove the duplicates in the SSL cipher suites list that could have
		// resulted from the upgrade to 8.0
        IAttributeSet topSet = broker.getAttributes();
		IAttributeSet sslSet = (IAttributeSet)topSet.getAttribute("BROKER_SSL_PARAMETERS");
		IAttributeMetaData sslMetaData = topSet.getAttributeMetaData("BROKER_SSL_PARAMETERS");
		
		if (((sslMetaData == null) || !sslMetaData.isFromTemplate()) &&
            (sslSet != null))
		{
		    String ciphersSet = (String)sslSet.getAttribute("SSL_CIPHER_SUITES");
		    String newCiphersSet = "";
		    IAttributeMetaData cipherMeta = sslSet.getAttributeMetaData("SSL_CIPHER_SUITES");
		    if ((cipherMeta == null || !cipherMeta.isFromTemplate()) && ciphersSet != null)
		    {
		    	if (m_upgradeEnv.isDEBUG())
                {
                    System.out.println("TypesConfigUpgrade80.migrateToJSSE original ciphers " + ciphersSet);
                }
		    	StringTokenizer cipherTokenizer = new StringTokenizer(ciphersSet, ",");
		    	while (cipherTokenizer.hasMoreTokens())
		    	{
		    		String cipher = cipherTokenizer.nextToken();
		    		if (newCiphersSet.indexOf(cipher) < 0)
                     {
                        newCiphersSet = newCiphersSet + "," + cipher;	// the first one will leave a leading comma	 
		    		                                                   // testing for hasMoreTokens could still leave
		    		                                                   // us with a trailing comma as the tokens could
		    		                                                   // be duplicates
                    }
		    	}
		    	// get rid of the leading comma
		    	if (newCiphersSet.indexOf(",") > 0)
                {
                    newCiphersSet = newCiphersSet.substring(newCiphersSet.indexOf(",") + 1);
                }
		    	sslSet.setStringAttribute("SSL_CIPHER_SUITES", newCiphersSet);		    	
		    }
		}
		// FLOW_TO_DISK should be set to false if the the broker is 
		// a member of a cluster. The cluster CLUSTER_FLOW_TO_DISK will be set when the
		// cluster is upgraded. Save the value of this broker's FLOW_TO_DISK
		// before changing it to false.
		IAttributeSet refs = (IAttributeSet)topSet.getAttribute("CONFIG_ELEMENT_REFERENCES");
		Reference clusterRef = null;
		if (refs != null)
        {
            clusterRef = (Reference)refs.getAttribute("CLUSTER_CONFIG_ELEMENT_REF");
        }
        if (clusterRef != null)
        {
            IAttributeMetaData clusterMetaData = refs.getAttributeMetaData("CLUSTER_CONFIG_ELEMENT_REF");
            boolean clusterFromTemplate = clusterMetaData != null && clusterMetaData.isFromTemplate();
            IAttributeSet pubsub = (IAttributeSet)topSet.getAttribute("BROKER_PUBSUB_PARAMETERS");
            IAttributeMetaData pubsubMetaData = topSet.getAttributeMetaData("BROKER_PUBSUB_PARAMETERS");
            boolean pubsubFromTemplate = pubsubMetaData != null && pubsubMetaData.isFromTemplate();

            if (! (clusterFromTemplate && pubsubFromTemplate))
            {
                if (pubsub != null)
                {
                    m_ftdValues.put(broker.getIdentity().getName(), (Boolean)pubsub.getAttribute("FLOW_TO_DISK"));
                    pubsub.setBooleanAttribute("FLOW_TO_DISK", Boolean.FALSE);
                }
            }
        }
		return null;
	}

	@Override
    @SuppressWarnings("unchecked")
    public String upgradeMQ_CLUSTER(IDirElement cluster, UpgradeEnv env)
			throws Exception 
    {
	    boolean flowToDisk = false;
	    IAttributeSet topSet = cluster.getAttributes();
	    IAttributeSet clusterMembers = (IAttributeSet)topSet.getAttribute("CLUSTER_MEMBERS");
	    // if the cluster members are inherited from a template, then the 
	    // CLUSTER_FLOW_TO_DISK will be inherited from the template as well
        IAttributeMetaData membersMetaData = topSet.getAttributeMetaData("CLUSTER_MEMBERS");
        
        if (((membersMetaData == null) || !membersMetaData.isFromTemplate()))
        {
            Collection<Reference> memberRefs = (Collection<Reference>)clusterMembers.getAttributes().values();
            for (Reference ref : memberRefs)
            {
                Boolean ftd = m_ftdValues.get(ref.getElementName());
                if (ftd != null && ftd.booleanValue())
                {
                    // we can stop looking
                    flowToDisk = true;
                    break;
                }// if the broker has not been upgraded, look at its value
                
                IDirElement broker = env.dsFileSystem.getFSElement(ref.getElementName(), false);
                IAttributeSet pubSub = (IAttributeSet)broker.getAttributes().getAttribute("BROKER_PUBSUB_PARAMETERS");
                if (pubSub != null)
                {
                    ftd = (Boolean)pubSub.getAttribute("FLOW_TO_DISC");
                    if (ftd != null && ftd.booleanValue())
                    {
                        flowToDisk = true;
                        break;
                    }
                }
            }
            topSet.setBooleanAttribute("CLUSTER_FLOW_TO_DISK", flowToDisk);
        }
		return null;
	}

	@Override
    public String upgradeXQ_CONTAINER(IDirElement xqContainer, UpgradeEnv env)
			throws Exception 
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	private void upgradeContainerMetrics(IDirElement container, UpgradeEnv env) throws ConfigException
	{
	    modifyMetrics(container.getAttributes());
	}
	
	private void upgradeComponentMetrics(IDirElement container, UpgradeEnv env) throws ConfigException
	{
	    IAttributeSet topSet = container.getAttributes();
	    IAttributeSet componentsSet = (IAttributeSet)topSet.getAttribute(IContainerConstants.COMPONENTS_ATTR);
	    if (componentsSet != null && !componentsSet.getAttributes().isEmpty())
	    {
	        for (String componentName : ((HashMap<String,IAttributeSet>)componentsSet.getAttributes()).keySet())
	        {
	            IAttributeSet componentSet = (IAttributeSet)componentsSet.getAttribute(componentName);
	            modifyMetrics(componentSet);	            
	        }
	    }	    
	}
	
	private void modifyMetrics(IAttributeSet parentSet) throws ConfigException
	{
	    IAttributeSet existingMetrics = (IAttributeSet)parentSet.getAttribute(IContainerConstants.ENABLED_METRICS_ATTR);
        if (existingMetrics != null)
        {
            HashMap<String, IAttributeSet> enabledAlerts = new HashMap<String, IAttributeSet>();
            HashMap<String, IAttributeSet> enabledMetrics = existingMetrics.getAttributes();
            parentSet.deleteAttribute(IContainerConstants.ENABLED_METRICS_ATTR);
            IAttributeSet newMetrics = parentSet.createAttributeSet(IContainerConstants.ENABLED_METRICS_ATTR);
            for (String metric : enabledMetrics.keySet())
            {
                IAttributeSet thresholds = enabledMetrics.get(metric);
                if (!thresholds.getAttributes().isEmpty())
                {
                    enabledAlerts.put(metric, thresholds);
                }
                // remove the unstarred version if we're putting in the starred version
                if (metric.endsWith("*"))
                {
                    String withoutStar = metric.substring(0, metric.length() - 2);
                    if (newMetrics.getAttribute(withoutStar) != null)
                    {
                        newMetrics.deleteAttribute(withoutStar);
                    }
                }
                // do no insert the metric if the starred version is there already
                if (newMetrics.getAttribute(metric + ".*") == null)
                {
                    newMetrics.setStringAttribute(metric, metric);
                }
            }
            IAttributeSet newEnabledAlerts = null;
            if (!enabledAlerts.isEmpty())
            {
                newEnabledAlerts = parentSet.createAttributeSet(IContainerConstants.ENABLED_ALERTS_ATTR);
                for (String alert : enabledAlerts.keySet())
                {
                    IAttributeSet thresholds = enabledAlerts.get(alert);
                    IAttributeSet indivAlert = newEnabledAlerts.createAttributeSet(alert);
                    String threshold = null;
                    if ((threshold = (String)thresholds.getAttribute(IContainerConstants.HIGH_THRESHOLDS_ATTR)) != null)
                    {
                        indivAlert.setStringAttribute(IContainerConstants.HIGH_THRESHOLDS_ATTR, threshold);
                    }
                    if ((threshold = (String)thresholds.getAttribute(IContainerConstants.LOW_THRESHOLDS_ATTR)) != null)
                    {
                        indivAlert.setStringAttribute(IContainerConstants.LOW_THRESHOLDS_ATTR, threshold);
                    }
                    
                }
            }
        }
	}

}
