package com.sonicsw.mf.common.config.upgrade;

import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.directory.IDirectoryService;

public class UpgradeEnv implements IMigrationProcess
{	
	IDirectoryAdminService dsAdmin = null;
    IDirectoryFileSystemService dsFileSystem = null;
    IDirectoryService dsSource = null;
    DirectoryService dsService = null;
    String connectURL = null;
    String connectUsername = null;
    String connectPassword = null;
    String mnode = null;
    String domain = null;
    Vector upgradeConfigList = new Vector();
    Vector upgradePathList = new Vector();
    String outFile = "." + System.getProperty("file.separator") + "Upgrade.txt"; // default file to catch errors   
    IDSTransaction m_curTransaction = null;
    Utils m_utils = null;
    Properties m_upgradeEnv = new Properties();
    HashMap m_containerProps = new HashMap();
    boolean m_debug = false;
    
    static boolean s_debugAll;
    static 
    {
        String debugProp = System.getProperty("DebugAll.debug");
        if (debugProp != null)
        {
            s_debugAll = new Boolean(debugProp).booleanValue();
        }
    }
    
	
	public UpgradeEnv(Properties upgradeEnv)
	{
		m_upgradeEnv = upgradeEnv;
		if (m_upgradeEnv != null)
		{
			String debugPropValue = (String) upgradeEnv.getProperty("migrate.debug");
			if (debugPropValue != null)
            {
                m_debug = new Boolean(debugPropValue).booleanValue();
            }
			if (isDEBUG())
            {
                System.out.println("UpgradeEnv hashtable constructor");
            }
		}
		m_utils = new Utils(this);
	}
	
	public UpgradeEnv(Properties upgradeProps, HashMap containerProps)
	{
		this(upgradeProps);
		m_containerProps = containerProps;
		
	}
	
	void connectToNewPSEDirectoryService() throws Exception
    {
        if (isDEBUG())
        {
            System.out.println("UpgradeEnv.createNewPSEDirectoryService called");
        }
        
        String destDir = (String)m_upgradeEnv.get(DSHOSTPROP);
        IDirElement dsElement = (IDirElement)m_upgradeEnv.get(DMDSELEMENTPROP);
        if (isDEBUG())
        {
            System.out.println("UpgradeEnv.createNewPSEDirectoryService for ds element " + dsElement.getIdentity().getName() + " to connect, destDir = " + destDir);
        }
        dsService = new DirectoryService(dsElement, null, destDir, true);
        dsAdmin = dsService.getAdminService();
        dsFileSystem = dsService.getFileSystemService();
    }
	
	
	void setDsAdmin(IDirectoryAdminService dsAdminArg)
	{
		dsAdmin = dsAdminArg;
	}
	
	void setDsFileSystem(IDirectoryFileSystemService dsFileService)
	{
		dsFileSystem = dsFileService;
	}
	
	Utils getUtils()
	{
		return m_utils;
	}
	
	// assumes this property is never null, since the constructors always
	// set it.
	public final boolean isDEBUG()
	{
		return m_debug || s_debugAll;
	}
	
	public static final boolean isDebugAll()
    {
        return s_debugAll;
    }
	
	public Object getProp(String propName)
	{
		return m_upgradeEnv.get(propName);
	}
	
	public void putProp(String propName, Object value)
	{
		m_upgradeEnv.put(propName, value);
	}
	
	public Object getContainerProp(String containerName, String prop)
	{
		HashMap containerMap = (HashMap)m_containerProps.get(containerName);
		if (containerMap != null)
        {
            return containerMap.get(prop);
        }
        else
        {
            return null;
        }
	}
}
