package com.sonicsw.mf.common.config.upgrade;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class Utils implements IMigrationProcess
{
	private static String FILE_SEPARATOR = System.getProperties().getProperty("file.separator");
	
	UpgradeEnv m_upgradeEnv = null;
	
	public Utils(UpgradeEnv env)
	{
		m_upgradeEnv = env;
		
	}
	String replaceAll(String origString, String[] removeString, String replaceWith)
    {
        return replaceAll(origString, removeString, replaceWith, false);
    }

    // added the boolean argument. We were always returning the original string if the 
    // resulting string was empty, though I can't remember why. In the case of fixSystemFolders,
    // and empty string is fine.
    String replaceAll(String origString, String[] removeString, String replaceWith, boolean canBeEmpty)
    {
        String result = "";
        for (int i=0; i< removeString.length; i++)
       {
           int subsStart = origString.indexOf(removeString[i]);
           if (subsStart > -1)
           {
               result = origString.substring(0, subsStart) + replaceWith +
                   origString.substring(origString.indexOf(removeString[i]) + removeString[i].length());
               break;
           }
       }
       if (result.length() == 0 && !canBeEmpty)
    {
        return origString;
    }
    else
    {
        return result;
    }
    }
    
    void fixProductAndReleaseVersion(String logicalName, String storageSuffix) throws Exception
    {
      if (m_upgradeEnv.isDEBUG())
      {
          System.out.println("ConfigUpgrade.fixProductAndReleaseVersion called for logical name == " + logicalName);
          String storageName = m_upgradeEnv.dsFileSystem.logicalToStorage(logicalName);
          System.out.println("ConfigUpgrade.fixProductAndReleaseVersion found storage name == " + storageName);
      }
      m_upgradeEnv.dsAdmin.setElementReleaseVersion(m_upgradeEnv.dsFileSystem.logicalToStorage(logicalName) + storageSuffix, CURRENT_RELEASE_VERSION);
      fixViewVersions(logicalName);

    }

    void fixProductAndReleaseVersion(String configName) throws Exception
    {
        fixProductAndReleaseVersion(configName, "");
    }
    
    void fixViewVersions(String viewName) throws Exception
    {
      fixViewVersionsHelper(viewName, true);
      if (viewName.indexOf("_Default") > 1)
      {
          String parentFolder = viewName.substring(0, viewName.lastIndexOf("/"));
          // Change the version of the parent directory as well
          fixViewVersionsHelper(parentFolder, true);
      }

    }


    void fixViewVersionsHelper(String viewPath, boolean fixReleaseVersion) throws Exception
    {
        HashMap metaAttributes = m_upgradeEnv.dsFileSystem.getMetaAttributes(viewPath);
        if (metaAttributes != null)
        {
            String attrs = (String) metaAttributes.get("TOOL_ATTRIBUTES");
            if (attrs != null)
            {
                if (fixReleaseVersion)
                {
                	for (String relVersion : SUPPORTED_PRODUCT_VERSIONS.values())
                    {
                        attrs = attrs.replace(relVersion, CURRENT_RELEASE_VERSION);
                    }
                }
                for (String prodVersion : SUPPORTED_PRODUCT_VERSIONS.keySet())
                {
                    attrs = attrs.replace(prodVersion, CURRENT_PRODUCT_VERSION);
                }
                metaAttributes.put("TOOL_ATTRIBUTES", attrs);
                if (m_upgradeEnv.isDEBUG())
                {
                    System.out.println("ConfigUpgrade.fixVuewVersionsHelper setting meta attributes, m_curTransaction == " + m_upgradeEnv.m_curTransaction);
                }
                if (m_upgradeEnv.m_curTransaction != null)
                {
                    m_upgradeEnv.m_curTransaction.addSetAttributes(viewPath, metaAttributes);
                }
                else {
                    m_upgradeEnv.dsFileSystem.setMetaAttributes(viewPath, metaAttributes);
                // TEST
                //attrs = (String) metaAttributes.get("TOOL_ATTRIBUTES");
                }
            }
        }
    }

    boolean fixPath(IAttributeSet parentSet, AttributeName attrPath, String newValue) throws Exception
    {
      // This code is assuming that it sees attribute sets everytime it gets a level of the attribute name.
      // It will have to be recoded if this isn't true in the future
        String brokerName = (String)parentSet.getAttribute("BROKER_NAME");
        IAttributeMetaData metaData = null;
        if (newValue != null)
        {
              IAttributeSet topSet = parentSet;
              for (int i = 0; i < attrPath.getComponentCount() - 1; i++)
              {
                  if (topSet != null)
                  {
                      String currentAttribute = (String) attrPath.getComponent(i);
                      metaData = topSet.getAttributeMetaData(currentAttribute);
                      if ( (metaData == null) || !metaData.isFromTemplate()) 
                      {
                          topSet = (IAttributeSet) topSet.getAttribute(currentAttribute);
                      }
                    else
                    {
                        return false;
                    }
                  }
                else
                {
                    return false;
                }
              }
              metaData = topSet.getAttributeMetaData( (String) attrPath.getComponent(attrPath.getComponentCount() - 1));
              if ((metaData == null) || !metaData.isFromTemplate())
              {
                  topSet.setStringAttribute( (String) attrPath.getComponent(attrPath.getComponentCount() - 1), newValue);
                  return true;
              }                 
         }
         return false;
     }
    
//  Starting with 7.0, set the HOST_DIRECTORY to an absolute path always
    void fixHOST_DIRECTORY(IDirElement DS, String newDSHostDir) throws Exception
    {       
        DS.getAttributes().setStringAttribute("HOST_DIRECTORY", newDSHostDir);         
    }  
    
    void upgradeBrokerAndDBPaths(IDirElement brokerEl) throws Exception
    {
        if (m_upgradeEnv.isDEBUG())
        {
            System.out.println("ConfigUpgrade.upgradeBrokerAndDBPaths calling fixPath for MQSTORE_DB_CONNECT for " + brokerEl.getIdentity().getName());
        }
        String parentContainerName = (String)m_upgradeEnv.getProp(CONTAINERNAMEPROP);
        if (parentContainerName == null)
         {
            return; // for instance, from the SMC
        }
        if (m_upgradeEnv.getContainerProp(parentContainerName, DBACTIONPROP) == null)
         {
            return; // keep the old values until it's time to do something with the DB
        }
        IAttributeSet topSet = brokerEl.getAttributes();
        AttributeName fixPath = new AttributeName("BROKER_DATABASE_PARAMETERS");
        fixPath.setNextComponent("MQSTORE_DB_CONNECT");
        String newMQStore = (String)m_upgradeEnv.getContainerProp(parentContainerName, MQSTOREPROP);
        if (newMQStore != null)
        {
            fixPath(topSet, fixPath, newMQStore);
        }
        fixPath = new AttributeName("BROKER_RECOVERY_LOG_PARAMETERS");
        fixPath.setNextComponent("RECOVERY_LOG_PATH");
        String logFile = (String)m_upgradeEnv.getContainerProp(parentContainerName, LOGFILEPROP);
        if (logFile != null)
        {
            fixPath(topSet, fixPath, logFile);
        }
    }
    
    static String addToUpgradeMessage(String source, String append)
    {
  	  if (source == null)
    {
        return append;
    }
    else
  	  {
  		  if (append == null)
        {
            return source;
        }    		  
  		  return source + System.getProperty("line.separator") + append;
  	  }
    }
    
    String getProductVersion(String configName) throws Exception 
    {        
        HashMap metaAttributes = m_upgradeEnv.dsFileSystem.getMetaAttributes(configName);

        if (metaAttributes != null)
        {
            String attrs = (String) metaAttributes.get("TOOL_ATTRIBUTES");
            if (attrs != null)
            {
                StringTokenizer tokenizer = new StringTokenizer(attrs, ";", false);
                while (tokenizer.hasMoreTokens())
                {
                    String attr = tokenizer.nextToken();
                    if (attr.startsWith("PRODUCT_VERSION"))
                    {
                        if (m_upgradeEnv.isDEBUG())
                        {
                            System.out.println("ConfigUpgrade.getProductVersion for " + configName + " == " + attr.substring(16));
                        }
                        return attr.substring(16);
                    }
                }
            }
        }
        if (m_upgradeEnv.isDEBUG())
        {
            System.out.println("ConfigUpgrade.getProductVersion for " + configName + " not found");
        }
        return "";
    }
    
    Vector getContainerComponents(IDirElement containerConfig)
    {
    	Vector components = new Vector();
    	IAttributeSet componentsSet = (IAttributeSet)containerConfig.getAttributes().getAttribute("COMPONENTS");
        Iterator keyIterator = componentsSet.getAttributes().keySet().iterator();
        while (keyIterator.hasNext())
        {
            String key = (String)keyIterator.next();
            IAttributeSet componentAttrs = (IAttributeSet)componentsSet.getAttribute(key);
            Reference compRef = (Reference)componentAttrs.getAttribute("CONFIG_REF");
            String compName = compRef.getElementName();
            components.add(compName);
        }
    	return components;
    }
    
    public void saveFileContents(File saveHere, String contents) throws IOException
    {
    	FileOutputStream outStream = new FileOutputStream(saveHere);
    	outStream.write(contents.getBytes());
    	outStream.close();
    }
    
    public void debug(String printThis)
	{
		if (m_upgradeEnv.isDEBUG())
        {
            System.out.println(printThis);
        }
	}
    
    public static void copyAll(File fromDir, File toDir) throws IOException
	{
		if (!toDir.exists())
        {
            toDir.mkdirs();
        }
		File [] children = fromDir.listFiles();
		for (int i=0; i<children.length; i++)
		{
			File child = children[i];
			if (child.isDirectory())
            {
                copyAll(new File(fromDir, child.getName()), new File(toDir, child.getName()));
            }
            else 
			{
				FileInputStream in = new FileInputStream(new File(fromDir, child.getName()));
		        FileOutputStream out = new FileOutputStream(new File(toDir, child.getName()));
		    
		        // Transfer bytes from in to out
		        byte[] buf = new byte[1024];
		        int len;
		        while ((len = in.read(buf)) > 0) 
		        {
		            out.write(buf, 0, len);
		        }
		        in.close();
		        out.close();
			}
		}		
	}
    
    public static void recursiveDeleteDirectory(File directory)
    {
    	if (directory.exists())
    	{
		    File[] contents = directory.listFiles();
		    for (int i = 0; i < contents.length; i++) 
		    {
			    if (contents[i].isDirectory())
                {
                    recursiveDeleteDirectory(contents[i]);
                }
			    //System.out.println("Deleting " + contents[i]);
			    contents[i].delete();
			    // DS storage files are hanging around after the delete, possibly
			    // because some thread has it locked even though we've closed the
			    // storage.
			    if (contents[i].exists())
                {
                    contents[i].deleteOnExit();
                }
		    }
		    directory.delete();
		    if (directory.exists())
            {
                directory.deleteOnExit();
            }
    	}
	}
    
    public static String replaceBackSlashes(String withSlashes)
    {
    	String strConverted = withSlashes;
		if (strConverted.indexOf("\\") > -1)
        {
            strConverted = strConverted.replaceAll("\\\\", "/");
        }
		return strConverted;
    }
    
    public static ArrayList findContainersForComponent(String componentName, IDirectoryFileSystemService ds)
        throws Exception
    {
        Query allContainersQuery = new Query();
        ArrayList inContainers = new ArrayList();
        IElementIdentity[] allContainers = null;
        IDirElement[] fsContainers = null;

        Query containerTypeQuery = new Query();
        containerTypeQuery.setFrom(new FromElementType("MF_CONTAINER"));
        fsContainers = ds.getFSElements(containerTypeQuery, false);
        if ((allContainers == null) && (fsContainers == null))
        {
            throw new Exception("Could not find any containers in the DS!");
        }
        int containerCount = ((allContainers != null) ? allContainers.length : fsContainers.length);
        for (int i=0; i< containerCount; i++)
        {
            IDirElement container = null;
            String containerName = null;

            container = fsContainers[i];
            containerName = container.getIdentity().getName();
            IAttributeSet components = (IAttributeSet)container.getAttributes().getAttribute("COMPONENTS");
            IAttributeSet componentSet = findComponent(components, componentName);
            if (componentSet != null)
            {
                inContainers.add(containerName);
            }   
        }
        return inContainers;
    }
    private static IAttributeSet findComponent(IAttributeSet componentsSet, String idToFind)
    {
        HashMap setMap = componentsSet.getAttributes();
        Collection mapValues = setMap.values();
        Iterator valuesIT = mapValues.iterator();
        while (valuesIT.hasNext())
        {
            IAttributeSet componentSet = (IAttributeSet)valuesIT.next();
            Reference compReference = (Reference)componentSet.getAttribute("CONFIG_REF");
            if (compReference.getElementName().toLowerCase().compareTo(idToFind.toLowerCase()) == 0)
            {
                return componentSet;
            }
        }
        return null;
    }
    
	public static void printError(String title, Exception e, String message)
	{
		System.err.println();
		System.err.print("*****************************  ");
		System.err.print(title);
		System.err.println(" ****************************");
		System.err.println();
		if (message != null)
		{
			System.err.println(message);
		    System.err.println();
		}
		if (e != null)
		{
			e.printStackTrace();
			System.err.println();
		}
		System.err.println("******************************************************************************");
	}
}

