package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public abstract class VersionedDomainManager implements IMigrationProcess, IVersionedDomainManagerUpgrade
{
	UpgradeEnv m_upgradeEnv = null;
	
	private String HIERARCHICAL_DIRECTORY = HIERARCHICAL_TYPES_PATH + getUpgradedReleaseVersion() + IMFDirectories.MF_DIR_SEPARATOR;

    private String[] HIERARCHICAL_TYPES = new String[]
    {
    	HIERARCHICAL_DIRECTORY + "MQ_BROKER",
    	HIERARCHICAL_DIRECTORY + "MQ_BACKUPBROKER",
    	HIERARCHICAL_DIRECTORY + "MF_DIRECTORY_SERVICE",
    	HIERARCHICAL_DIRECTORY + "MF_BACKUP_DIRECTORY_SERVICE",
    	HIERARCHICAL_DIRECTORY + "MF_AUTHENTICATION_DOMAIN",
    	HIERARCHICAL_DIRECTORY + "MQ_AUTHORIZATION_POLICY",
    	HIERARCHICAL_DIRECTORY + "MQ_CLUSTER",
        HIERARCHICAL_DIRECTORY + "MQ_WS_PROTOCOL"
    };


	@Override
    public void preConnectUpgrade(UpgradeEnv env) throws Exception 
	{
		// TODO Auto-generated method stub

	}
	@Override
    public String upgrade(UpgradeEnv env) throws Exception 
	{
		m_upgradeEnv = env;
		fixMFLibrary();
		initHierarchicalTypes();
		return null;
	}
	
	protected void fixMFLibrary()
    throws DirectoryServiceException, ReadOnlyException
    {
		// remove validators
	    m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MQ_100_" + getProductVersion(), null);
	    m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MF_100_3.1", null);
	    m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/ESB_" + getProductVersion(), null);
	    m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/ds_handlers/ESBJndiHandler", null);
	    // delete the associated jar files from the DS
		// need to check if they're actually present because the base release version 
		// might be something other than 8.0 and we might be here on our way to the
		// most recent version
		IDirElement jarFile = m_upgradeEnv.dsFileSystem.getFSElement("/System/DS/Validators/MQ/" + getProductVersion() + "/MQtriggers.jar", true);
		if (jarFile != null)
		{
			m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
		    m_upgradeEnv.dsFileSystem.deleteFSElement("/System/DS/Validators/MQ/" + getProductVersion() + "/MQtriggers.jar");
		}
		jarFile = m_upgradeEnv.dsFileSystem.getFSElement("/System/DS/Validators/MF/" + getProductVersion() + "/MFtriggers.jar", true);
		if (jarFile != null)
		{
			m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
			m_upgradeEnv.dsFileSystem.deleteFSElement("/System/DS/Validators/MF/" + getProductVersion() + "/MFtriggers.jar");
		}
		jarFile = m_upgradeEnv.dsFileSystem.getFSElement("/System/SonicESB/" + getProductVersion() + "/lib/xq_validator.jar", true);
        if (jarFile != null)
        {
            m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
            m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SonicESB/" + getProductVersion() + "/lib/xq_validator.jar");
        }
        fix75MFLibrary();
    }

    /**
     * MQ-34628: Migration of ESB fails from 762 to 2013
     * 7.6 upgrade code does not remove the xq_validator.jar of 7.5 version. Because of which it is causing
     * an issue while upgrading 7.6 which was earlier upgraded from 7.5 to 8.6.
     * Introduced this method to remove the 7.5 xq_validator entries from the domain.
     *
     */
    private void fix75MFLibrary()  {
        try {
            m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/ESB_7.5", null);
            IDirElement jarFile;
            jarFile = m_upgradeEnv.dsFileSystem.getFSElement("/System/SonicESB/7.5/lib/xq_validator.jar", true);
            if (jarFile != null)
            {
                m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
                m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SonicESB/7.5/lib/xq_validator.jar");
            }
        } catch (DirectoryServiceException e) {
            e.printStackTrace();
        } catch (ReadOnlyException e) {
            e.printStackTrace();
        }
    }
	
	protected void initHierarchicalTypes() throws DirectoryServiceException
    {
    	try
    	{
    	    m_upgradeEnv.dsAdmin.createDirectory(HIERARCHICAL_DIRECTORY);
    	}
    	catch (DirectoryServiceException dirE) {} //already exists
    	
    	for (int i=0; i< HIERARCHICAL_TYPES.length; i++)
    	{
    		if (m_upgradeEnv.dsAdmin.getElement(HIERARCHICAL_TYPES[i], false) == null)
    			// create it
    		{
    			IDirElement type = ElementFactory.createElement(HIERARCHICAL_TYPES[i], "HIERARCHICAL_TYPE", getProductVersion());
    			m_upgradeEnv.dsAdmin.setElement(type, null);
    		}
    	}
    }

}
