/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.dirconfig;
import java.io.Serializable;
import java.util.HashMap;

// Should be used for unforseen cases in the future - must be kept serialization compatible across all DS versions.
public class DirectoryServiceGeneralException extends DirectoryServiceException implements Serializable
{
  private static final long serialVersionUID = 0L;
  private final static int SERIALIZATION_VERSION = 3;
  private HashMap m_map;

  public DirectoryServiceGeneralException(String errorMessage, HashMap map)
  {
       super(errorMessage);
       m_map = map;
  }

  public HashMap getMap()
  {
      return m_map;
  }

  private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
  {
       s.writeInt(SERIALIZATION_VERSION);
       s.writeObject(m_map);
  }

  private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
  {
      int version = s.readInt();
      if (version != SERIALIZATION_VERSION)
    {
        throw new java.io.IOException("Serialization version mismatch. Serialized object version: " +
                                         version + " class version: " + SERIALIZATION_VERSION);
    }

      m_map = (HashMap)s.readObject();
  }

}
