/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.dirconfig;
import java.io.Serializable;
import java.util.HashMap;

public class DirectoryServiceTriggerException extends DirectoryServiceException implements Serializable
{
  private static final long serialVersionUID = 0L;
  private final static int SERIALIZATION_VERSION = 3;
  private Throwable m_validationThrowable;

  public DirectoryServiceTriggerException(String componentName, Throwable t)
  {
       super("Trigger failed, trigger ID=\"" + componentName + "\"", t);

       if (t instanceof Serializable)
    {
        m_validationThrowable = t;
    }
  }

  public final Throwable getTriggerThrowable()
  {
      return m_validationThrowable;
  }

  private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
  {
       s.writeInt(SERIALIZATION_VERSION);
       HashMap map = new HashMap();
       if (m_validationThrowable != null && m_validationThrowable instanceof Serializable)
    {
        map.put("THROWABLE", m_validationThrowable);
    }

       s.writeObject(map);
  }

  private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
  {
      int version = s.readInt();
      if (version != SERIALIZATION_VERSION)
    {
        throw new java.io.IOException("Serialization version mismatch. Serialized object version: " +
                                         version + " class version: " + SERIALIZATION_VERSION);
    }

      HashMap map = (HashMap)s.readObject();
      m_validationThrowable = (Throwable)map.get("THROWABLE");
  }

}
