/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.dirconfig;

/**
 * This exception is thrown when an attempt to apply an out-of-sync modification delta to an IDirElement object.
 * or when trying to set a new IDirElement object while the old one exists.
 *
 * The format of the getMessage() message is "[elementName] <error message>".
 */
public final class VersionOutofSyncException extends DirectoryServiceException
{
    public VersionOutofSyncException(String err)
    {
        super(err);
    }

    public VersionOutofSyncException(String err, Throwable cause)
    {
        super(err, cause);
    }

    @Override
    public String toString()
    {
        return "VersionOutofSyncException: " + getMessage();
    }

}
