/*
 * Copyright (c) 2002, Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * PROGRESS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 */

package com.sonicsw.mf.common.license;

/* This code was adapted from the Coder32Common class located in
   the progress.message.util.license package.  Please refer to
   that class for background history and details. 01/28/05 */

final class Coder32Common
{
/*
    public final static boolean bTraceEvents = true;
/*/
    public final static boolean bTraceEvents = false;
//*/

    final static long DEFAULT_SEED = 19500624L;
    final static int DEFAULT_BYTESIZE = 6;

    // encode/decode bit stream by groups of BYTESIZE bits
    int	BYTESIZE;	// number of bits encoded into 1 byte
    int	SETSIZE;
    int	MASK;
    int	N_MASK;
    int	GAP;

    char[]	m_charSet = null;
    int[]	m_Ascii = new int[256];	// reversed m_charSet

    Coder32Common()
    {
        this(DEFAULT_BYTESIZE, DEFAULT_SEED);
    }

    Coder32Common( int byteSize )
    {
        this(byteSize, DEFAULT_SEED);
    }

    Coder32Common( int byteSize, long seed )
    {
        BYTESIZE = byteSize;
        SETSIZE = 1 << BYTESIZE;
        MASK = SETSIZE - 1;
        N_MASK = ~MASK;
        GAP = 8 - BYTESIZE;

        String s = "0123456789abcdefghjkmnpqrstuvwxyzoABCDEFGHJKLMNPQRSTUVWXYZ#+-$#=";
        //          0123456789012345678901234567890123456789012345678901234567890123

        int		i;
        char[]	buf = s.substring(0,SETSIZE).toCharArray();
        if (bTraceEvents)
        {
            System.out.println ("BYTESIZE " + BYTESIZE + ", SETSIZE " + SETSIZE);
        }

        int[]	a = new int[buf.length];

        // shuffle them:
        Random16 rand = new Random16( seed );
        for( i = 0; i < a.length; i++ )
        {
            // Add the character at the end of a random
            // value.  We will sort this, and then remove
            // the random bits. (wood)
            // Old code:
            // a[i] = ( rand.nextInt() & ~0xffff) | buf[i];
            a[i] = ((rand.nextInt() & 0xfff) << 16) | buf[i];
            if(bTraceEvents)
            {
                System.out.println(""+i+": "+Integer.toHexString(a[i])+" ["+buf[i]+" "+Integer.toHexString((a[i] & 0xffff))+"]");
            }
        }

        for( i = 0; i < a.length - 1; i++ )
        {
            int	save = i;
            int	tmp = a[i];
            for( int j = a.length - 1; j > i; j-- )
            {
                if( tmp > a[j] )
                {
                    tmp = a[j];
                    save = j;
                }
            }
            if( save != i )
            {
                //if(bTraceEvents)System.out.println("swap "+i+" and "+save);
                a[i] ^= a[save];
                a[save] ^= a[i];
                a[i] ^= a[save];
            }
        }
        /*
        if(bTraceEvents)
                for( i = 0; i < a.length; i++ )
                    abUtil.out.println(""+i+": "+a[i]);
        */

        m_charSet = new char[buf.length];
        for( i = 0; i < m_charSet.length; i++ )
        {
            m_charSet[i] = (char)( a[i] & 0xffff );
            if(bTraceEvents)
            {
                System.out.println("char  "+i+": "+ m_charSet[i] + " " + ( a[i] & 0xffff ) );
            }
        }


        for( i = 0; i < 256; i++ )
        {
            m_Ascii[i] = -1;
        }

        for( i = 0; i < m_charSet.length; i++ )
        {
            m_Ascii[m_charSet[i]] = i;
        }
    }
}
