/*
 * Copyright (c) 2002, Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * PROGRESS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 */

package com.sonicsw.mf.common.license;

/* This code was adapted from the Coder32Decode class located in
   the progress.message.util.license package.  Please refer to
   that class for background history and details. 01/28/05 */

final class Coder32Decode
{
/*
    public final static boolean bTraceEvents = true;
/*/
    public final static boolean bTraceEvents = false;
//*/

    Coder32Common coder32;

    Coder32Decode()
    {
        coder32 = new Coder32Common ();
    }

    Coder32Decode( int byteSize )
    {
        coder32 = new Coder32Common (byteSize);
    }

    Coder32Decode( int byteSize, long seed )
    {
        coder32 = new Coder32Common (byteSize, seed);
    }

    byte[] decode( String s ) throws Exception
    {
        byte[]	b = new byte[s.length()];       //*DBE*/ 1.0 ok here
        s.getBytes( 0, s.length(), b, 0 );
        for( int i = 0; i < b.length; i++ )
        {
            int	k = coder32.m_Ascii[b[i]];
            if( k < 0 )
            {
                if(bTraceEvents)
                {
                    throw new Exception( "Invalid data "+i );
                }
                else
                {
                    throw new Exception( "Invalid data" );
                }
            }

            b[i] = (byte)k;
        }
        b = _decode( b );
        return b;
    }

    private byte[] _decode( byte[] b ) throws Exception
    {
        int		size = b.length;
        int		inSize = size * coder32.BYTESIZE / 8;
        if( inSize == 0 || inSize == size * (coder32.BYTESIZE - 1) / 8 )
        {
            throw new Exception( "Invalid data" );
        }

        if(bTraceEvents)
        {
            System.out.println("decode in  "+LicenseCommon._toHexString(b));
        }
        byte[]	bi = new byte[inSize];
        byte	w = 0;
        int		offs = 0, j = 0, i = 0;

        for( i = 0; i < size; i++ )
        {
            if( (b[i] & coder32.N_MASK) != 0 )
            {
                throw new Exception( "Invalid data" );
            }

            if( offs == 0 )
            {
                w = b[i];
            }
            else
            {
                if( offs > coder32.BYTESIZE  )
                {
                    w = (byte)( (w << coder32.BYTESIZE) | b[i] );
                    offs = offs - coder32.BYTESIZE - coder32.GAP;
                }
                else
                {
                    bi[j++] = (byte)( (w << offs) | (b[i] >>> (coder32.BYTESIZE - offs)) );
                    w = b[i];
                }
            }
            offs = (offs + coder32.GAP) % 8;
        }
        if(bTraceEvents)
        {
            System.out.println("decode out "+LicenseCommon._toHexString(bi));
        }
        return bi;
    }
}
