/*
 * Copyright (c) 2002, Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * PROGRESS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 */

package com.sonicsw.mf.common.license;

/* This code was adapted from the LicenseCommon class located in
   the progress.message.util.license package.  Please refer to
   that class for background history and details. 01/28/05 */

final class LicenseCommon
{
    static final int PASSLEN = 9;

    static final int SIZE_LICENSE = 4;
    static final int SIZE_PROD    = 2;
    static final int SIZE_COUNT   = 2;
    static final int SIZE_CRC     = 1;

/*
    final static boolean bTraceEvents = true;
/*/
    final static boolean bTraceEvents = false;
//*/

    static void _encrypt( byte[] b, Random16 r )
    {
        for( int i = 0; i < b.length; i++ ) {
            b[i]= (byte)(b[i] ^ (r.nextInt() & 0xff ));
        }
    }

    static void _arraycopy( byte[] src, byte[] dst, int pos )
    {
        // assume that src is shorter
        int srcPos = 0;
        int dstPos = pos;
        int len = src.length;

        if( len > dst.length )
        {
            // dst is shorter
            srcPos = pos;
            dstPos = 0;
            len = dst.length;
        }
        System.arraycopy( src, srcPos, dst, dstPos, len );
    }

    static byte _getCRC( byte[] b, byte crc )
    {
        for( int i = b.length - 1; i >= 0; i-- )
        {
            crc = (byte)( crc + b[i] + i );
        }
        return crc;
    }

    static long _fromBytes( byte[] b )
    {
        long n = 0;
        for( int i = b.length - 1; i >= 0; i-- )
        {
            int j = b[i] & 0xff;
            n = (n << 8) + j;
        }
        return n;
    }

    static byte[] _toBytes( long n, int len )
    {

        byte b[] = new byte[len];
        for( int i = 0; i < len; i++ )
        {
            b[i] = (byte)(n & 0xff);
            n >>>= 8;
        }
        return b;
    }

    static String _toDecString ( byte[] b )
    {
        String s = "";
        if (b == null)
        {
            return s;
        }
        int len = b.length;
        if (len == 0)
        {
            return s;
        }
        for( int i = 0; i < len; i++ )
        {
            s += (int)b[i] & 0xff;
            if (i < len - 1)
            {
                s += ", ";
            }
        }
        return s;
    }

    static String _toHexString(byte[] b)
    {
        String s = "";
        if (b == null)
        {
            return s;
        }
        int len = b.length;
        if (len == 0)
        {
            return s;
        }

        for( int i = 0; i < len; i++ )
        {
           int j = (int)b[i] & 0xff;
           String ch = Integer.toString( j, 16 );
           if( j < 16 ) {
              s += "0" + Integer.toString( j, 16 );
           } else {
              s += Integer.toString( j, 16 );
           }
         }
      return s;
   }

    static int getSeed( String version )
    throws Exception
    {
        if( version == null )
        {
            throw new Exception("Version is mandatory");
        }

        int   len = version.length() - 1;
        while( len >= 0 )
        {
            if( Character.isDigit(version.charAt(len)) )
            {
                ++len;
                break;
            }
            --len;
        }
        float f = Float.valueOf(version.substring(0, len)).floatValue();

        if(bTraceEvents)
        {
            System.out.println("float "+f);
        }

        return (int)(f * 10);
    }
}
