/*
 * Copyright (c) 2002, Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * PROGRESS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 */

package com.sonicsw.mf.common.license;

/* This code was adapted from the LicenseDecoder class located in
   the progress.message.util.license package.  Please refer to
   that class for background history and details. 01/28/05 */

public final class LicenseDecoder
{

/*
    public final static boolean bTraceEvents = true;
/*/
    public final static boolean bTraceEvents = false;
//*/

    int product = 0;
    int serial = 0;
    int count = 0;

    public LicenseDecoder (String version, String cc)
    throws Exception
    {
        decrypt (version, cc);
    }

    public final int getProduct()
    {
        return product;
    }

    public final int getSerial()
    {
        return serial;
    }

    public final int getCount()
    {
        return count;
    }

    synchronized void decrypt( String version, String pass0 )
    throws Exception
    {
        try
        {
            int	seed = LicenseCommon.getSeed( version );

            Coder32Decode c = new Coder32Decode(5);

            byte[] b = c.decode(pass0.toLowerCase());
            if( b.length != LicenseCommon.PASSLEN )
            {
                throw new Exception("password length error"+b.length);
            }

            int pos = 0;

            byte[]	prodBytes = new byte[LicenseCommon.SIZE_PROD];
            LicenseCommon._arraycopy( b, prodBytes, pos );
            pos += prodBytes.length;

            byte[]	crcBytes = new byte[LicenseCommon.SIZE_CRC];
            LicenseCommon._arraycopy( b, crcBytes, pos );
            pos += crcBytes.length;

            byte[]	countBytes = new byte[LicenseCommon.SIZE_COUNT];
            LicenseCommon._arraycopy( b, countBytes, pos );
            pos += countBytes.length;

            byte[]	licenseBytes = new byte[LicenseCommon.SIZE_LICENSE];
            LicenseCommon._arraycopy( b, licenseBytes, pos );
            pos += licenseBytes.length;

            Random16 r = new Random16( seed );

            LicenseCommon._encrypt( prodBytes, r );
            LicenseCommon._encrypt( crcBytes, r );
            LicenseCommon._encrypt( countBytes, r );
            LicenseCommon._encrypt( licenseBytes, r );

            byte crc = LicenseCommon._getCRC( prodBytes, (byte)0);
            crc = LicenseCommon._getCRC( countBytes, crc);
            crc = LicenseCommon._getCRC( licenseBytes, crc);

            byte crcOld = (byte)LicenseCommon._fromBytes( crcBytes );

            if( crcOld != crc )
            {
                if(bTraceEvents)
                {
                    System.out.println ("crc=" + Integer.toHexString((int)crc) + ",crcOld= " + Integer.toHexString((int)crcOld));
                }
                throw new Exception("CRC error");
            }

            count = (int)LicenseCommon._fromBytes( countBytes );
            product = (int)LicenseCommon._fromBytes( prodBytes );
            serial = (int)LicenseCommon._fromBytes( licenseBytes );

            if(bTraceEvents)
            {
                System.out.println("pass0=" + pass0);
                System.out.println("license="+serial+", prod="+product+", count="+count+ ", crc=" + crc + ",crcOld=" + crcOld);
            }
        }
        catch( Exception e )
        {
            if(bTraceEvents)
            {
                e.printStackTrace();
            }
            throw new Exception("password is not valid for control code " + pass0, e);
        }
    }

    public static void main( String args[] )
    throws Exception
    {
        String   version = null;
        String   cc = null;
        int	   i = 0;

        try
        {
            while( i < args.length)
            {
                try
                {
                    String	arg = args[i++].toLowerCase();

                    if (arg.equals("-v"))
                    {
                        version = args[i++];
                    }
                    else if (arg.equals("-w"))
                    {
                        cc = args[i++];
                    }
                    else
                    {
                        System.out.println("WARNING\tUnknown option: " + arg);
                    }
                } catch( ArrayIndexOutOfBoundsException a ) {
                    break;
                }
            }

            // Now try to decode

            LicenseDecoder ld = null;
            ld = new LicenseDecoder (version, cc);
            System.out.println( "LicenseDecoder Product: \"" + ld.getProduct() + "\"" );
            System.out.println( "LicenseDecoder Count: \"" + ld.getCount()+ "\"" );
            System.out.println( "LicenseDecoder Serial: \"" + ld.getSerial()+ "\"\n" );
        }
        catch( Exception e )
        {
         e.printStackTrace(System.out);
         System.out.println("\nUSAGE: java LicenseDecoder -w <cc> -v <version> \n");
        }
    }
}
