/*
 * Copyright (c) 2002, Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * PROGRESS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 */

package com.sonicsw.mf.common.license;


/* This code was adapted from the LicenseMgr class located in
   the progress.message.broker package.  Please refer to that
   class for background history and details. 01/28/05 */

abstract public class LicenseMgr
{
    protected static boolean DEBUG = false;

    protected int m_product;
    protected String m_productName;
    protected int m_count;
    protected int m_serial;
    protected String m_controlNumber;
    protected String m_ipAddress = null; // used to determine whether or not an IP Address
    protected int m_evalPeriod = -1 ;
    protected boolean m_eval = false ;

    public LicenseMgr (String controlCode)
    throws Exception
    {
    }

    abstract public String getLicenseBanner();

    /**
     * evalExpiredCheck() tests whether the evaluation period has expired. This
     *  method can be called whether or not the license is an eval license. For
     *  a non-eval license, the evaluation period never expires.
     * @throws EExpiredEvaluationLicenseKey if the license is an eval license
     *  and the eval period has expired.
     * @throws Exception
     *
     */
    abstract protected void evalExpiredCheck() throws Exception;

    public int getProductCode()
    {
        return m_product;
    }

    public String getProductName()
    {
        return m_productName;
    }

    public int getSerial()
    {
        return m_serial;
    }
}
