/*
 * Copyright (c) 2002, Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * PROGRESS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 */

 /*
 * An instance of this class is used to generate a stream of
 * pseudorandom numbers. The class uses a 18-bit seed, which is
 * modified using a linear congruential formula. (See Donald Knuth,
 * <i>The Art of Computer Programming, Volume 2</i>, Section 3.2.1.)
 * <p>
 * If two instances of <code>Random</code> are created with the same
 * seed, and the same sequence of method calls is made for each, they
 * will generate and return identical sequences of numbers.
 * <p>
 * Many applications will find the <code>random</code> method in
 * class <code>Math</code> simpler to use.
 *
 * This class is a subset of the java Random.java class from SUN with
 * the following changes:
 *     - nextInt() returns only a 16-bit (not 32-bit) integer
 *       (Note: all uses of nextInt() in progress.message.* use
 *        8 or 16-bit.)
 *     - all methods are package only (not public).
 *
 * @author  Bill Wood
 * @version 1.00, 10/28/97
 */

package com.sonicsw.mf.common.license;

/* This code was adapted from the Random16 class located in
   the progress.message.util.license package.  Please refer to
   that class for background history and details. 01/28/05 */

class Random16 {
    private long seed;
    private final static long multiplier = 0xCE677L;
    private final static long addend = 0xBL;
    private final static long seedBits = 18;
    private final static long mask = (1L << seedBits) - 1;

    public final static boolean bTraceEvents = false;

    /**
     * Creates a new random number generator using a single
     * <code>long</code> seed.
     *
     * @param   seed   the initial seed.
     */
    Random16(long seed) {
        setSeed(seed);
        if (bTraceEvents)
        {
            System.out.println ("new Random with seed:" + String.valueOf(seed));
            System.out.println ("multiplier " + String.valueOf(multiplier));
            System.out.println ("addend " + String.valueOf(addend));
            System.out.println ("mask " + String.valueOf(mask));
            System.out.println ("seed " + String.valueOf(this.seed));
        }
    }

    /**
     * Sets the seed of this random number generator using a single
     * <code>long</code> seed.
     *
     * @param   seed   the initial seed.
     */
    final synchronized void setSeed(long seed) {
        this.seed = (seed * multiplier + addend) & mask;
    }

    /**
     * Generates the next pseudorandom number. Subclass should
     * override this, as this is used by all other methods.
     *
     * @param   bits random bits
     * @return  the next pseudorandom value from this random number generator's sequence.
     * @since   JDK1.1
     */
    synchronized private int next(int bits) {
        long nextseed = (seed * multiplier + addend) & mask;
        seed = nextseed;
        return (int)(nextseed >>> (seedBits - bits));
    }

    /**
     * Returns the next pseudorandom, uniformly distributed <code>int</code>
     * value from this random number generator's sequence. This returns
     * a 16-bit positive integer.
     *
     * @return  the next pseudorandom, uniformly distributed <code>int</code>
     *          value from this random number generator's sequence.
     */
    int nextInt() {  return next(16); }

}
