package com.sonicsw.mf.common.metrics;

import java.io.Serializable;

/**
 * An AggregatedMetric extends the basic metric by encapsulating the sources
 * of the metrics from which the aggregate metric value was derived.
 *
 * @see IMetric
 */
public interface IAggregateMetric
extends Serializable
{
    public static final short TOTAL_AGGREGATION_TYPE = 0;
    public static final short AVERAGE_AGGREGATION_TYPE = 1;
    public static final short MAXIMUM_AGGREGATION_TYPE = 2;
    public static final short MINIMUM_AGGREGATION_TYPE = 3;

    /**
     * Gets the source components that provided the metrics from which the
     * aggregate metric value was derived.
     */
    public String[] getSources();

    /**
     * Gets the metric identity of the metric.
     */
    public IMetricIdentity getMetricIdentity();

    /**
     * Gets the array aggregate metric values indexed by aggregation type.
     *
     * @see #TOTAL_AGGREGATION_TYPE
     * @see #AVERAGE_AGGREGATION_TYPE
     * @see #MAXIMUM_AGGREGATION_TYPE
     * @see #MINIMUM_AGGREGATION_TYPE
     */
    public long[] getValues();

    /**
     * Gets the currency of the aggregated metric (an average of the currency time
     * of all the contributing metrics).
     */
    public long getCurrencyTimestamp();
}
