/**
 * Copyright (c) 1998-2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.common.metrics;

/**
 * An alert defines a high or low threshold value for a particular metric.
 *
 * One or more alerts can be associated with an individual metric, an instance metric, or
 * all instances of an instance metric parent.
 *
 * A notification is issued whenever the value of a metric exceeds the threshold of one of its
 * associated alerts (either high or low).
 */

public interface IAlert
{
    /**
     * Returns the metric identity for this alert
     */
    IMetricIdentity getMetricIdentity();

    /**
     * True if this is a high threshold alert, false if a low threshold.
     */
    boolean isHighThreshold();

    /**
     * Returns the alert's threshold value
     */
    long getThresholdValue();

    /**
     * Determines whether two alerts are equal
     */
    @Override
    boolean equals(Object o);

    /**
     * Determines wheter two alerts have the same metric
     * identity.
     * Compares this metric identity with the given metric
     * identity
     * @param metricIdentity to be compared with this alert
     * @return true if they are equals
     */
    boolean sameMetricIdentity(IMetricIdentity metricIdentity);
}