package com.sonicsw.mf.common.metrics;


/**
 * A metric provides the numeric value of a metric identity (as captured at some point
 * in time).
 *
 * @see IMetricsData
 */
public interface IMetric
{
    /**
     * Gets the metric identity of the metric.
     */
    public IMetricIdentity getMetricIdentity();

    /**
     * Gets the metric value.
     */
    public long getValue();

    /**
     * Gets the triggered alerts
     */
    public IAlert[] getTriggeredAlerts();

    /**
     * Gets the currency of the metric (the time the statistical data was last
     * updated prior to metric evaluation).
     */
    public long getCurrencyTimestamp();
}
