/**
 * Copyright (c) 1998-2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mf.common.metrics;

import java.io.Serializable;

/**
 * A metric info object provides meta-data about one of the following:
 * <ul>
 * <li>an instance metric parent                       (e.g. "connection.messages.ReceivedPerSecond")
 * <li>an individual normal (i.e. non-instance) metric (e.g. "broker.connections.Count")
 * </ul>
 * Instance metrics are described by their instance metric parent's meta-data and thus
 * metric info objects for such instance metrics will not exist.  In other words, there will not be
 * an IMetricInfo object for an instance metric, but there will be one for the instance metric's parent.
 */
public interface IMetricInfo
extends Serializable
{
    /**
     * Gets the metric identity.
     */
    public IMetricIdentity getMetricIdentity();

    /**
     * Gets the metrics value type.
     *
     * @see IValueType
     */
    public short getValueType();

    /**
     * Gets the optional full description of the metric.
     */
    public String getDescription();

    /**
     * Extended data allows any additional meta information that a component wishes to
     * convey about a metric. The management framework is agnostic about what this
     * field is used for.
     */
    public String getExtendedData();

    /**
     * If true, the meta-data is for an instance metric parent, and the information
     * provided can be applied to all of the individual instances of that instance metric parent.
     */
    public boolean isInstanceMetric();

    /**
     * If a metric is dynamic it means it can be dynamically enabled/disabled through
     * the components management API.
     */
    public boolean isDynamic();

    /**
     * Indicates whether the metric supports high threshold alerts
     */
    public boolean supportsHighThresholdAlerts();

    /**
     * Indicates whether the metric supports low threshold alerts
     */
    public boolean supportsLowThresholdAlerts();

    /**
     * Describes the units that this metric uses.
     */
    public String getUnits();


}
