package com.sonicsw.mf.common.metrics;

import java.io.Serializable;

/**
 * Classes that implement this interface encapsulate multiple metrics and their runtime
 * value at a particular collection time.
 *
 * Management clients request metrics data from a component.
 */
public interface IMetricsData
extends Serializable
{
    /**
     * Gets the time the metrics were collected by the component. This
     * time will be based on the system clock of the host the component's
     * container is running on.
     */
    public long getCurrencyTimestamp();
    
    /**
     * Gets the metrics captured in this object.
     */
    public IMetric[] getMetrics();
}
