package com.sonicsw.mf.common.metrics;

/**
 * Metric values are one of the types described in this interface. A given metric's
 * value type can be obtained from the metric's meta-data (see {@link IMetricInfo}).
 */
public interface IValueType
{
    /**
     * A metric of this type repesents a value captured at a point in time.
     */
    public static final short VALUE = 0;
    /**
     * A metric of this type repesents the number of times a value is updated.
     */
    public static final short COUNT = 1;
    /**
     * A metric of this type repesents the total of all the values in a set of historical values.
     */
    public static final short TOTAL = 2;
    /**
     * A metric of this type repesents the minimum value from a set of historical values.
     */
    public static final short MINIMUM = 3;
    /**
     * A metric of this type repesents the maximum value from a set of historical values.
     */
    public static final short MAXIMUM = 4;
    /**
     * A metric of this type repesents the average of all the values in a set of historical values.
     */
    public static final short AVERAGE = 5;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the total of all the values in a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds)
     * <BR>&nbsp;&nbsp;c = 100
     * </pre>
     */
    public static final short UTILIZATION = 6;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the maximum value from a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds) over which the max value was collected
     * <BR>&nbsp;&nbsp;c = 100
     */
    public static final short PEAK_UTILIZATION = 7;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the total of all the values in a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds)
     * <BR>&nbsp;&nbsp;c = 1000
     * </pre>
     */
    public static final short PER_SECOND_RATE = 8;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the maximum value from a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds) over which the max value was collected
     * <BR>&nbsp;&nbsp;c = 1000
     * </pre>
     */
    public static final short PEAK_PER_SECOND_RATE = 9;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the total of all the values in a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds)
     * <BR>&nbsp;&nbsp;c = 60000
     * </pre>
     */
    public static final short PER_MINUTE_RATE = 10;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the maximum value from a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds) over which the max value was collected
     * <BR>&nbsp;&nbsp;c = 60000
     * </pre>
     */
    public static final short PEAK_PER_MINUTE_RATE = 11;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the total of all the values in a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds)
     * <BR>&nbsp;&nbsp;c = 3600000
     * </pre>
     */
    public static final short PER_HOUR_RATE = 12;
    /**
     * A metric of this type repesents:
     * <p>
     * &nbsp;&nbsp;(a / b) * c
     * <p>
     * where:
     * <p>&nbsp;&nbsp;a = the maximum value from a set of historical values
     * <BR>&nbsp;&nbsp;b = the elapsed time (milliseconds) over which the max value was collected
     * <BR>&nbsp;&nbsp;c = 3600000
     * </pre>
     */
    public static final short PEAK_PER_HOUR_RATE = 13;

    /**
     * A textual description of the value type may be obtained using a
     * value type as an index into the array.
     *
     * @see IMetricInfo#getValueType()
     */
    public static final String[] DESCRIPTIONS = new String[]
    {
        "Value",
        "Count",
        "Total",
        "Minimum",
        "Maximum",
        "Average",
        "Utilization",
        "Peak Utilization",
        "Per Second Rate",
        "Peak Per Second Rate",
        "Per Minute Rate",
        "Peak Per Minute Rate",
        "Per Hour Rate",
        "Peak Per Hour Rate",
    };

    /**
     * The number of default value types
     */
    public static final int NUM_VALUE_TYPES = 14;
}
