package com.sonicsw.mf.common.metrics.impl;

import com.sonicsw.mf.common.metrics.IAggregateMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;

/**
 * An AggregateMetric provides aggregate metric values for a given metric.
 */
public final class AggregateMetric
implements IAggregateMetric
{
    String[] m_sources;
    IMetricIdentity m_id;
    long[] m_values;
    long m_currencyTimestamp;

    public AggregateMetric(String[] sources, IMetricIdentity id, long[] values, long currencyTimestamp)
    {
        m_sources = sources;
        m_id = id;
        m_values = values;
        m_currencyTimestamp = currencyTimestamp;
    }

    /**
     * @see com.sonicsw.mf.common.metrics.IAggregateMetric#getSources()
     */
    @Override
    public String[] getSources() { return m_sources; }

    /**
     * @see com.sonicsw.mf.common.metrics.IAggregateMetric#getMetricIdentity()
     */
    @Override
    public IMetricIdentity getMetricIdentity() { return m_id; }

    /**
     * @see com.sonicsw.mf.common.metrics.IAggregateMetric#getValues()
     */
    @Override
    public long[] getValues() { return m_values; }

    /**
     * @see com.sonicsw.mf.common.metrics.IAggregateMetric#getCurrencyTimestamp()
     */
    @Override
    public long getCurrencyTimestamp() { return m_currencyTimestamp; }
}
