package com.sonicsw.mf.common.metrics.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.MetricsFactory;

/**
 * A HistoricalMetric extends the basic metric by encapsulating the source of the metric.
 */
public final class HistoricalMetric
extends Metric
implements IHistoricalMetric, Serializable
{
    private static final long serialVersionUID = -8018080999357982594L;
    private static final short m_serialVersion = 0;

    private String m_source;

    public HistoricalMetric(String source, IMetricIdentity id, long value, long currencyTimestamp)
    {
        super(id, value, currencyTimestamp);
        m_source = source;
    }

    HistoricalMetric() { }

    /**
     * Gets the source component that created the metric.
     */
    @Override
    public String getSource() { return m_source; }


    //
    // Serialization
    //

    // You can add to these, but never remove
    private static final short SOURCE_FIELD = 0;
    private static final short ID_FIELD = 1;
    private static final short VALUE_FIELD = 2;
    private static final short CURRENCY_FIELD = 3;

    // This is done more efficiently than in other places where we employ version
    // handling serialization code .. as there may be many metrics to describe

    private void writeObject(ObjectOutputStream stream)
    throws IOException
    {
        short fieldCount = 4;

        // we know how many fields we will write and serial version will always be written
        stream.writeShort(fieldCount);
        stream.writeShort(m_serialVersion);

        // HistoricalMetric specific fields

        stream.writeShort(SOURCE_FIELD);
        stream.writeObject(m_source);

        stream.writeShort(ID_FIELD);
        stream.writeObject(super.getMetricIdentity().getNameComponents());

        stream.writeShort(VALUE_FIELD);
        stream.writeLong(super.getValue());

        stream.writeShort(CURRENCY_FIELD);
        stream.writeLong(super.getCurrencyTimestamp());
    }

    private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException
    {
        // read the number of items and stuff them in a hash map
        short numFields = stream.readShort();
        short serialVer = stream.readShort();
        for (int i = 0; i < numFields; i++)
        {
            short field = stream.readShort();
            switch (serialVer)
            {
                // case olderVersion<n> ...
                default:
                    if (field == SOURCE_FIELD)
                    {
                        m_source = (String)stream.readObject();
                    }
                    else if (field == ID_FIELD)
                    {
                        super.m_id = MetricsFactory.createMetricIdentity((String[])stream.readObject());
                    }
                    else if (field == VALUE_FIELD)
                    {
                        super.m_value = stream.readLong();
                    }
                    else if (field == CURRENCY_FIELD)
                    {
                        super.m_currencyTimestamp = stream.readLong();
                    }
                    break;
            }
        }
    }
}
