package com.sonicsw.mf.common.metrics.impl;

import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;

/**
 * Class is not for reference and construction, rather you should use the factory and interface.
 *
 * @see com.sonicsw.mf.common.metrics.MetricsFactory#createMetric(IMetricIdentity, long)
 * @see com.sonicsw.mf.common.metrics.IMetricIdentity
 */
public class Metric
implements IMetric
{
    IMetricIdentity m_id;
    long m_value;
    IAlert[] m_triggeredAlerts = null;
    long m_currencyTimestamp;

    Metric() { } // required by classes that extend Metric

    public Metric(IMetricIdentity id, long value, long currencyTimestamp)
    {
        m_id = id;
        m_value = value;
        m_currencyTimestamp = currencyTimestamp;
    }

    /**
     * @see com.sonicsw.mf.common.metrics.IMetric#getMetricIdentity()
     */
    @Override
    public IMetricIdentity getMetricIdentity() { return m_id; }

    /**
     * @see com.sonicsw.mf.common.metrics.IMetric#getValue()
     */
    @Override
    public long getValue() { return m_value; }

    /**
     * @see com.sonicsw.mf.common.metrics.IMetric#getTriggeredAlerts()
     */
    @Override
    public IAlert[] getTriggeredAlerts() { return m_triggeredAlerts; }

    /**
     * @see com.sonicsw.mf.common.metrics.IMetric#getCurrencyTimestamp()
     */
    @Override
    public long getCurrencyTimestamp() { return m_currencyTimestamp; }

    // set triggered alerts
    public void setTriggeredAlerts(IAlert[] alerts)
    {
        m_triggeredAlerts = alerts;
    }
}
