package com.sonicsw.mf.common.metrics.manager;


/**
 * Metric analyzers take the value(s) of a raw statistic and perform some analysis to
 * derive a particular metric value type.
 *
 * The default metrics manager is capable of providing default analyzer implementation
 * instances for the well known metric value types.
 *
 * Well known metric value types are defined in IValueType.
 *
 * @see MetricsManager
 * @see com.sonicsw.mf.common.metrics.IValueType
 */
public interface IMetricAnalyzer
{
    /**
     * Analyze the value(s) of the given statistic to derive a single metric value.
     *
     * @return An array containing 2 values; the metric value, the currency timestamp (i.e.
     *         the time that the data the metric is based on was last updated.
     */
    public long[] evaluateValue(IStatistic statistic);
}
