package com.sonicsw.mf.common.metrics.manager;

/**
 * A sampled statistic provides a single raw statistical value that is maintained by sampling.
 * The metrics manager requests a set of statistic providers to update the raw data each
 * refresh interval.
 *
 * @see IStatistic
 * @see IHistoricalStatistic
 * @see IHistoricalSampledStatistic
 * @see IMetricAnalyzer
 * @see MetricsManager
 */
public interface ISampledStatistic
extends IStatistic
{
    /**
     * Gets the list of statistic providers that are associted with this statistic.
     */
    public IStatisticProvider[] getStatisticProviders();
}
