package com.sonicsw.mf.common.metrics.manager;

/**
 * A statistic provider is responsible for updating a statistic value at the end of a refresh
 * interval (sampling period) maintained by the metrics manager. The metrics manager will call the
 * updateStatistic(ISampledStatistic) method on each of the statistic providers associated with a
 * sampled statistic.
 *
 * @see ISampledStatistic
 * @see IHistoricalSampledStatistic
 * @see MetricsManager
 */
public interface IStatisticProvider
{
    /**
     * Update the given statistic's value.
     */
    public void updateStatistic(ISampledStatistic statistic);

    /**
     * Reinitializes the statistic managed by the provider.
     * The metrics manager will call this for each provider known to it.
     */
    public void resetStatistic(ISampledStatistic statistic);
}
