/**
 * Copyright (c) 1998-2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Progress.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mf.common.metrics.manager;

import com.sonicsw.mf.common.metrics.manager.impl.HistoricalSampledStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.HistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.SampledStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.Statistic;

/**
 * Component developers are required to use the factory to create statistic instances.
 */
public final class StatisticsFactory
{
    /**
     * Creates a default statistic implementation that will exhibit the update behavior
     * associated with the mode.
     *
     * @param updateMode      The update mode to be assigned to the returned statistic.
     * @param intervalMode    If false, the current value at each refresh interval (determined by the metrics manager)
     *                        is the actual value as updated or sampled.
     *                        If true, the current value at each refresh interval is computed as the difference
     *                        between the actual value at the current refresh interval and the actual value at the
     *                        end of the last refresh interval.
     * @param providers       The statistic providers to be associated with the returned statistic.
     *                        The MetricsManager will call the providers to update the statistic
     *                        each refresh interval. If the statistic should not be sampled by the
     *                        MetricsManager, then a null value should be supplied.
     * @param historyMode     The history mode has the following values; 0 - maintain no history, 1 - maintain
     *                        a set of prior values as captured at each refresh interval and collected over the
     *                        collection period, 2 - in addition to the that specified by 1 (above), maintain
     *                        the number of updates that occurred on the statistic for each refresh interval
     *                        (collected over the collection interval.
     *
     * @see IStatistic#VALUE_MODE
     * @see IStatistic#DIFFERENCE_MODE
     * @see IStatistic#COUNTER_MODE
     * @see IStatistic#MAXIMUM_MODE
     * @see IStatistic#MINIMUM_MODE
     * @see IStatistic#MAXIMUM_COUNTER_MODE
     * @see IStatistic#MINIMUM_COUNTER_MODE
     * @see IStatistic
     * @see ISampledStatistic
     * @see IHistoricalStatistic
     * @see IHistoricalSampledStatistic
     */
    public static IStatistic createStatistic(short updateMode, boolean intervalMode, IStatisticProvider[] providers, short historyMode)
    {
        if (historyMode > 0)
        {
            boolean saveUpdateCounts = historyMode == 2;
            if (providers == null)
            {
                return new HistoricalStatistic(updateMode, intervalMode, saveUpdateCounts);
            }
            else
            {
                return new HistoricalSampledStatistic(updateMode, intervalMode, saveUpdateCounts, providers);
            }
        }
        else
        {
            if (providers == null)
            {
                return new Statistic(updateMode, intervalMode);
            }
            else
            {
                return new SampledStatistic(updateMode, intervalMode, providers);
            }
        }
    }

}
