package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IHistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IStatistic;

/**
 * A simple metric analyzer that returns the average of all the values over a set of events.
 */
public class Average
implements IMetricAnalyzer
{
    private static final boolean DEBUG = false;

    /**
     * @see IMetricsAnalyzer#evaluateValue(IStatistic)
     */
    @Override
    public long[] evaluateValue(IStatistic statistic)
    {
        long[] value = new long[2];
        long count = 0;
        long total = 0;

        if (statistic instanceof IHistoricalStatistic)
        {
            long[] values = null;
            long[] counts = null;
            synchronized(statistic)
            {
                values = ((IHistoricalStatistic)statistic).getLastValues();
                value[1] = statistic.getCurrencyTimestamp();
                counts = ((IHistoricalStatistic)statistic).getLastUpdateCounts();
            }

            if (counts == null)
            {
                if (values != null)
                {
                    count = values.length;
                }
            }
            else
            {
                if (DEBUG)
                {
                    System.out.println("Counts[] =");
                    ((HistoricalStatistic)((HistoricalStatistic)statistic).m_updateCountsStatistic).printValues();
                }
                for (int i = 0; i < counts.length; i++)
                {
                    count += counts[i];
                }
            }
            if (DEBUG)
            {
                System.out.println("Values[] = ");
                ((HistoricalStatistic)statistic).printValues();
            }
            if (!(values == null))
            {
                for (int i = 0; i < values.length; i++)
                {
                    total += values[i];
                }
            }
        }
        else
        {
            // non-historical statistic - calculate average since last reset(), using
            // current value, count and time.  Assumes the current value represents a total count!
            synchronized(statistic)
            {
                total = statistic.getCurrentValue();
                count = statistic.getLastUpdateCount();     // current running count
                value[1] = statistic.getCurrencyTimestamp();
            }
        }

        if (count != 0)
        {
            value[0] = Math.round((double)total / (double)count);
        }
        if (DEBUG)
        {
            System.out.println("Average value = " + value[0] + " total = " + total + ", count = " + count);
        }

        return value;
    }
}
