package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IStatistic;

/**
 * A simple metric analyzer that returns the number of times update was called on the
 * statistic since the last reset() was called.
 */
public class Count
implements IMetricAnalyzer
{
    /**
     * @see IMetricsAnalyzer#evaluateValue(IStatistic)
     */
    @Override
    public long[] evaluateValue(IStatistic statistic)
    {
        long[] value = new long[2];

        // get current count for both historical and non-historical statistics
        synchronized(statistic)
        {
            value[0] = statistic.getLastUpdateCount();  // get current running count
            value[1] = System.currentTimeMillis();
        }
        return value;
    }
}
