package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IHistoricalSampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;

/**
 * The default implementation of IHistoricalSampledStatistic.
 *
 * @see MetricsManager#createStatistic(short, IStatisticProvider[], boolean)
 */
public class HistoricalSampledStatistic
extends HistoricalStatistic
implements IHistoricalSampledStatistic
{
    protected IStatisticProvider[] m_providers;

    /**
     * Creates a historical sampled statistic with the given mode (see <>_MODE values) and
     * set of statistic providers.
     *
     * @param updateMode       The update mode of the statistic value
     * @param intervalMode     If true, the value and count as of the last refresh interval are returned as the
     *                         difference between the actual values at the last refresh interval and those of the
     *                         previous refresh interval.
     * @param providers        The set of statistic providers.
     * @param saveUpdateCounts In addition to recording the values at the end of each refesh interval, record
     *                         the number of updates that occured in that interval.
     *
     * @see IStatisticProvider
     */
    public HistoricalSampledStatistic(short updateMode, boolean intervalMode, boolean saveUpdateCounts, IStatisticProvider[] providers)
    {
        super(updateMode, intervalMode, saveUpdateCounts);
        m_providers = providers;
    }

    /**
     * @see ISampledStatistic#getStatisticProviders()
     */
    @Override
    public IStatisticProvider[] getStatisticProviders() { return m_providers; }
    
    @Override
    public String toString() { return "HistoricalSampledStatistic@" + Integer.toHexString(this.hashCode()) + ": name=" + m_name + ", updateMode=" + m_updateMode + ", intervalMode=" + m_intervalMode ;}
}
