package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IHistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IStatistic;

/**
 * A simple metric analyzer that returns the maximum value from a set of historical values.
 */
public class Maximum
implements IMetricAnalyzer
{
    /**
     * @see IMetricsAnalyzer#evaluateValue(IStatistic)
     */
    @Override
    public long[] evaluateValue(IStatistic statistic)
    {
        long[] value = new long[2];

        if (statistic instanceof IHistoricalStatistic)
        {
            long[] values = null;
            synchronized(statistic)
            {
                values = ((IHistoricalStatistic)statistic).getLastValues();
                value[1] = statistic.getCurrencyTimestamp();
            }
            if (!(values == null))
            {
                value[0] = values[0];
                for (int i = 0; i < values.length; i++)
                {
                    if (values[i] > value[0])
                    {
                        value[0] = values[i];
                    }
                }
            }
        }
        else
        {
            // non-historical statistic - get current value
            synchronized(statistic)
            {
                value[0] = statistic.getCurrentValue();
                value[1] = statistic.getCurrencyTimestamp();
            }
        }

        return value;
    }
}
