package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;

/**
 * The default implementation of ISampledStatistic.
 *
 * @see StatisticsFactory.createStatistic(short, boolean, IStatisticProvider[], short)
 */
public class SampledStatistic
extends Statistic
implements ISampledStatistic
{
    public IStatisticProvider[] m_providers;

    /**
     * Creates a statistic with the given mode (see <>_MODE values) and statistic
     * providers.
     *
     * @param updateMode      The update mode of the statistic value
     * @param intervalMode    If true, the value and count as of the last refresh interval are returned as the
     *                        difference between the actual values at the last refresh interval and the values
     *                        those of the previous refresh interval.
     * @param providers       The set of statistic providers.
     *
     * @see IStatisticProvider
     */
    public SampledStatistic(short updateMode, boolean intervalMode, IStatisticProvider[] providers)
    {
        super(updateMode, intervalMode);
        m_providers = providers;
    }

    /**
     * @see ISampledStatistic#getStatisticProviders()
     */
    @Override
    public IStatisticProvider[] getStatisticProviders() { return m_providers; }
    
    @Override
    public String toString() { return "SampledStatistic@" + Integer.toHexString(this.hashCode()) + ": name=" + m_name + ", updateMode=" + m_updateMode + ", intervalMode=" + m_intervalMode ;}
}
