package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IHistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IStatistic;

/**
 * A simple metric analyzer that returns the total of all the values in a set of historical values.
 */
public class Total
implements IMetricAnalyzer
{
    /**
     * @see IMetricsAnalyzer#evaluateValue(IStatistic)
     */
    @Override
    public long[] evaluateValue(IStatistic statistic)
    {
        long[] value = new long[2];

        if (statistic instanceof IHistoricalStatistic)
        {
            long[] values = null;
            synchronized(statistic)
            {
                values = ((IHistoricalStatistic)statistic).getLastValues();
                value[1] = statistic.getCurrencyTimestamp();
            }
            if (!(values == null))
            {
                for (int i = 0; i < values.length; i++)
                {
                    value[0] += values[i];
                }
            }
        }
        else
        {
            synchronized(statistic)
            {
                value[0] = statistic.getCurrentValue();
                value[1] = statistic.getCurrencyTimestamp();
            }
        }

        return value;
    }
}
