package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IStatistic;

/**
 * A simple metric analyzer that returns the value of a single statistic.
 */
public class Value
implements IMetricAnalyzer
{
    /**
     * @see IMetricsAnalyzer#evaluateValue(IStatistic)
     */
    @Override
    public long[] evaluateValue(IStatistic statistic)
    {
        long[] value = new long[2];

        // get current value and time for both historical and non-historical statistics
        synchronized(statistic)
        {
            value[0] = statistic.getCurrentValue();
            value[1] = System.currentTimeMillis();
        }
        return value;
    }
}
