package com.sonicsw.mf.common.runtime;

public interface IBackupStatus
{
    /**
     * The status of the current or most recent DS backup operation.
     * <p>
     * If no backup operation has ever been invoked:
     * <ul>
     * <li>isInProgress() == false
     * <li>getStartTime() == -1
     * <li>getCompletionTime() == -1
     * <li>getLocation() == ""
     * </ul>
     * <p>
     * If a backup operation is in progress:
     * <ul>
     * <li>isInProgress() == true
     * <li>getStartTime() == <invocation time at DS in millis>
     * <li>getCompletionTime() == -1
     * <li>getLocation() == backupPath
     * </ul>
     * <p>
     * If the most recent backup operation succeeded:
     * <ul>
     * <li>isInProgress() == false
     * <li>getStartTime() == <invocation time at DS in millis>
     * <li>getCompletionTime() == <completion time at DS in millis>
     * <li>getLocation() == backupPath
     * </ul>
     * <p>
     * If the most recent backup operation failed:
     * <ul>
     * <p>isInProgress() == false
     * <p>getStartTime()() == <invocation time at DS in millis>
     * <p>getCompletionTime() == -1
     * <p>getLocation() == backupPath
     * <ul>
     */
    
    /**
     * @return true if the backup is still running, false if it isn't.
     */
    public boolean isInProgress();
    
    /**
     * 
     * @return The start time of the last backup in milliseconds. -1 if no backup has been run.
     */
    public long getStartTime();
    
    /**
     * 
     * @return The finish time of the last backup in milliseconds. -1 if a backup has not been run 
     * or the last backup was not successful.
     */
    public long getCompletionTime();
    
    /**
     * 
     * @return The location of the last backup. Empty string if no backup has been run.
     */
    
    public String getLocation();

}
