package com.sonicsw.mf.common.runtime;

/**
 * The implmentation of this interface represents the canonical name form
 * of a container ot component.
 */
public interface ICanonicalName
extends Comparable
{
    /**
     * Gets the full composite name of the instance. The canonical name
     * will vary depending upon the instance implementation, for example:
     * <p>
     * <ul>
     * <li>a containers cananocial name might be: "Sonic.Container"
     * <li>a components cananocial name might be: "Sonic.Container:ID=SonicMQ"
     * </ul>
     */
    public String getCanonicalName();

    /** Get the domain name to which the instance belongs. */
    public String getDomainName();

    /** Get the container name within the domain. */
    public String getContainerName();

    /**
     * Get the component ID within the container (if the canonical name represents a component).
     */
    public String getComponentName();

    /**
     * Tests if the given object is equal to this canonical name.
     *
     * @return Returns true if the canonical name of this object equals that of the given object.
     *         Returns false if the given object is not an instance of ICanonicalName or the
     *         stringified names match.
     */
    @Override
    public boolean equals(Object object);

    /**
     * Compares this object with the specified object for order. Returns a negative integer,
     * zero, or a positive integer as this object is less than, equal to, or greater than
     * the specified object.
     *
     * @throws ClassCastException If the given object is not an instance of an ICanonicalName
     */
    @Override
    public int compareTo(Object object) throws ClassCastException;
}
