package com.sonicsw.mf.common.runtime;

/**
 * The implmentation of this interface represents the state of a child container
 * managed by an Activation Daemon.
 *
 * @see com.sonicsw.mf.jmx.client.IActivationDaemonProxy#getChildStates()
 */
public interface IChildContainerState
extends IState
{
    /** Indicates the child container state cannot be determined. */
    public static final short STATE_UNKNOWN  = 0;
    /**
     * Indicates the child container is offline.
     * The child container is either not contactable or a shutdown/deactivate
     * has triggered the offline state.
     */
    public static final short STATE_OFFLINE  = 1;
    /** Indicates the child container is inan inactive state (there are no schedules that indicate the child container should be running). */
    public static final short STATE_INACTIVE = 2;
    /** Indicates the child container is online (in operational state). */
    public static final short STATE_ONLINE   = 3;
    /** Textual representations of child container states (indexed by STATE_<> values). */
    public static final String[] STATE_TEXT =
        new String[] { "Unknown", "Offline", "Inactive", "Online" };

    /**
     * Gets the last known exit code of the child container.
     * <p>
     * The exit code will be recorded when the child container is shutdown, deactivated
     * or fails.
     *
     * @return The child container exit code or null if the child container has never been launched/activated.
     *         Exit codes are defined in IContainerExitCodes.
     *
     * @see IContainerExitCodes
     */
    public Integer getExitCode();

    /**
     * Gets the tail of the child containers stdout/stderr.
     *
     * @return The tail of messages/exceptions logged by the child container or null if the child container
     *         has never been launched/activated.
     */
    public String[] getLogTail();

    /**
     * Get the time the state value was captured.
     */
    public long getTimeStamp();
}
