package com.sonicsw.mf.common.runtime;


/**
 * Contains the status of a collective invocation of an operation or a collective setup of an attribute.
 *
 * @see com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy
 */
public interface ICollectiveOpStatus
{
   /**
    * Returns the number of collection components that were operated on.
    *
    * @return the number of collection components
    */
   public int getCount();

   /**
    * Returns the name of the compNum-th component. The name is the same as would be returned from
    * com.sonicsw.mf.common.runtime.IComponentIdentity.getCanonicalName.
    *
    * @param compNum the position of the component in the list
    *
    * @return the name of the compNum-th component
    */
   public String getComponentName(int compNum);

   /**
    * Returns true if the operation on the compNum-th component was successful.
    *
    * @param compNum the position of the component in the list
    *
    * @return true if the operation on the compNum-th component was successful
    */
   public boolean operationIsSuccessful(int compNum);

   /**
    * Returns the return value of the compNum-th operation.
    *
    * @param compNum the position of the component in the list
    *
    * @return the return value of the compNum-th operation. null is returned if it's a void method (or an attribute setup).
    *         null is also returned if operationIsSuccessful(compNum) returns false.
    */
   public Object getReturnValue(int compNum);

   /**
    * Returns the throwable object of a failed compNum-th operation.
    *
    * @param compNum the position of the component in the list
    *
    * @return Returns the throwable object of a failed compNum-th operation.
    *         null is also returned if operationIsSuccessful(compNum) returns true.
    */
   public Throwable getThrowable(int compNum);
}

