package com.sonicsw.mf.common.runtime;

import java.io.Serializable;

/**
 * Represents the identity of component runtime instances.
 *
 * @see IIdentity
 */
public interface IComponentIdentity
extends IIdentity, Serializable
{
    public static final String ID_PREFIX = "ID=";
    public static final int ID_PREFIX_LENGTH = ID_PREFIX.length();
    public static final String DELIMITED_ID_PREFIX = ":ID=";
    public static final int DELIMITED_ID_PREFIX_LENGTH = DELIMITED_ID_PREFIX.length();

    /**
     * Get the component ID within the container.
     */
    public String getComponentName();
}
