package com.sonicsw.mf.common.runtime;

import java.util.Map;

/**
 * Indicates the runtime state of a component within its container.
 *
 * @see com.sonicsw.mf.common.runtime.IContainerState
 * @see com.sonicsw.mf.common.runtime.IContainerState#getComponentStates()
 */
public interface IComponentState
extends IState
{
    /** Indicates the component state cannot be determined. */
    public static final short STATE_UNKNOWN  = 0;
    /**
     * Indicates the component is offline.
     * The component has been created but it is currently not in an
     * operational state.
     */
    public static final short STATE_OFFLINE  = 1;
    /** Indicates the component is starting (but not yet operational). */
    public static final short STATE_STARTING = 2;
    /** Indicates the component is online (in operational state). */
    public static final short STATE_ONLINE   = 3;
    /** Indicates the component is stopping. */
    public static final short STATE_STOPPING = 4;
    /** Textual representations of component states (indexed by STATE_<> values). */
    public static final String[] STATE_TEXT =
        new String[] { "Unknown", "Offline", "Starting", "Online", "Stopping" };

    /**
     * Get last error severity (uncleared condition with an error level < Level.INFO).
     *
     * @see com.sonicsw.mf.common.runtime.Level
     */
    public int getLastErrorLevel();

    /**
     * Get the textual description of the last uncleared condition with an error level < Level.INFO.
     */
    public String getLastErrorDescription();
    
    /**
     * Get the states of any sub-components. The keys of the HashMap represent the type of
     * sub-component.
     * 
     * @return A map of sub-component types to arrays of sub-component states. If no sub-component
     *         states are available, null will be returned.
     */
    public Map<String, ISubComponentState[]> getSubComponentStates();
}
