package com.sonicsw.mf.common.runtime;

/**
 * This interface describes the possible exit codes that may be generated on container termination.
 * <p>
 * The corresponding values are:
 * <p>
 * <table border="0" cellpadding="3" cellspacing="0" width="100%">
 *   <tbody>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>0</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#NORMAL_SHUTDOWN_EXIT_CODE">NORMAL_SHUTDOWN_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>1</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#UNSPECIFIED_FAILURE_EXIT_CODE">UNSPECIFIED_FAILURE_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>2</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#INVALID_CMD_LINE_EXIT_CODE">INVALID_CMD_LINE_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>3</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#BOOT_FILE_NOT_FOUND_EXIT_CODE">BOOT_FILE_NOT_FOUND_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>4</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#DS_FAILURE_EXIT_CODE">DS_FAILURE_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>5</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#DS_ALREADY_RUNNING_EXIT_CODE">DS_ALREADY_RUNNING_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>6</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#AM_ALREADY_RUNNING_EXIT_CODE">AM_ALREADY_RUNNING_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>7</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#CACHE_FAILURE_EXIT_CODE">CACHE_FAILURE_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>8</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#CONFIGURATION_FAILURE_EXIT_CODE">CONFIGURATION_FAILURE_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>9</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#COMMS_FAILURE_EXIT_CODE">COMMS_FAILURE_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>10</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#LIBX_DIR_NOT_FOUND_EXIT_CODE">LIBX_DIR_NOT_FOUND_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>11</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#DS_DUAL_ACTIVE_EXIT_CODE">DS_DUAL_ACTIVE_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>12</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#INSUFFICIENT_MEMORY_EXIT_CODE">INSUFFICIENT_MEMORY_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>13</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#CONTAINER_ALREADY_RUNNING_EXIT_CODE">CONTAINER_ALREADY_RUNNING_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>14</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#CONTAINER_RESTART_EXIT_CODE">CONTAINER_RESTART_EXIT_CODE</a>
 *       </td>
 *     </tr>
 *     <tr bgcolor="white" class="TableRowColor">
 *       <td rowspan="1" colspan="1" align="right">
 *         <b>15</b>
 *       </td>
 *       <td rowspan="1" colspan="1">
 *         <a href="#FAILED_TO_START_CONTAINER_FROM_CI_DEPLOYANDSTART">FAILED_TO_START_CONTAINER_FROM_CI_DEPLOYANDSTART</a>
 *       </td>
 *     </tr>
 *   </tbody>
 * </table>
 * @see #EXIT_CODE_TEXTS
 */
public interface IContainerExitCodes
{
    /**
     * Container process exit code on normal shutdown.
     */
    public static final int NORMAL_SHUTDOWN_EXIT_CODE = 0;
    /**
     * Container process exit code on an unclassified abnormal shutdown.
     */
    public static final int UNSPECIFIED_FAILURE_EXIT_CODE = 1;
    /**
     * Container process exit code when the container detects it was started with an invalid command line.
     */
    public static final int INVALID_CMD_LINE_EXIT_CODE = 2;
    /**
     * Container process exit code when the container has been unable to find it's boot file(s).
     */
    public static final int BOOT_FILE_NOT_FOUND_EXIT_CODE = 3;
    /**
     * Container process exit code on an unclassified Directory Service failure.
     */
    public static final int DS_FAILURE_EXIT_CODE = 4;
    /**
     * Container process exit code when on startup the Directory Service determined there is already an
     * existing Directory Service running in the same configuration domain.
     */
    public static final int DS_ALREADY_RUNNING_EXIT_CODE = 5;
    /**
     * Container process exit code when on startup the Agent Manager determined there is already an
     * existing Agent Manager running in the same deployment domain.
     */
    public static final int AM_ALREADY_RUNNING_EXIT_CODE = 6;
    /**
     * Container process exit code on an unclassified configuration cache failure.
     */
    public static final int CACHE_FAILURE_EXIT_CODE = 7;
    /**
     * Container process exit code on an unclassified configuration failure.
     */
    public static final int CONFIGURATION_FAILURE_EXIT_CODE = 8;
    /**
     * Container process exit code on a permanent (non-recoverable) communications failure.
     */
    public static final int COMMS_FAILURE_EXIT_CODE = 9;
    /**
     * The libX directory (for native libraries) does not exist.
     */
    public static final int LIBX_DIR_NOT_FOUND_EXIT_CODE = 10;
    /**
     * Two active fault tolerant DS have been detected.
     */
    public static final int DS_DUAL_ACTIVE_EXIT_CODE = 11;
    /**
     * Insufficient memory.
     */
    public static final int INSUFFICIENT_MEMORY_EXIT_CODE = 12;
    /**
     * Container process exit code when on startup the container determined there is already an
     * existing container of the same name running in the same deployment domain.
     */
    public static final int CONTAINER_ALREADY_RUNNING_EXIT_CODE = 13;
    /**
     * A special exit code used to indicate that the container was shutdown with the intent that any parent
     * shell or process will detect this code and restart the container. The following support the restart
     * behavior for this exit code: startcontainer.{bat|sh}, the activation daemon and the Windows service.
     */
    public static final int CONTAINER_RESTART_EXIT_CODE = 14;
    /**
     *The centralized install DeployAndStartContainer failed to start the JVM for the container process
     */
    public static final int FAILED_TO_START_CONTAINER_FROM_CI_DEPLOYANDSTART = 15;

    /**
     * An array holding textual equivalents to the <>_EXIT_CODE constants. Access using a
     * particular exit code string using: <code>IContainerExitCodes.EXIT_CODE_TEXTS[<>_EXIT_CODE]</code>.
     */
    public static final String[] EXIT_CODE_TEXTS = new String[]
    {
        "Normal shutdown",
        "Unspecified failure",
        "Invalid command line",
        "Boot file not found",
        "Directory Service failure",
        "Directory Service already running",
        "Agent Manager already running",
        "Configuration cache failure",
        "Configuration failure",
        "Permanent communications failure",
        "\"libX\" directory not found",
        "Dual-active Directory Services detected",
        "Insufficient memory",
        "Container already running",
        "Container restart",
        "Centralized install: container startup failure"
    };
}
