package com.sonicsw.mf.common.runtime;

/**
 * The implmentation of this interface represents the state of a container and
 * all its hosted components.
 *
 * @see IComponentState
 */
public interface IContainerState
extends IState
{
    /** Indicates the container state cannot be determined. */
    public static final short STATE_UNKNOWN  = IComponentState.STATE_UNKNOWN;
    /**
     * Indicates the container is offline.
     * The container is either not contactable or a shutdown
     * has been triggered the offline state.
     */
    public static final short STATE_OFFLINE  = IComponentState.STATE_OFFLINE;
    /** Indicates the container is online (in operational state). */
    public static final short STATE_ONLINE   = IComponentState.STATE_ONLINE;
    /** Textual representations of container states (indexed by STATE_<> values). */
    public static final String[] STATE_TEXT = IComponentState.STATE_TEXT;

    /**
     * Get a list of the state of all the components hosted by the container.
     */
    public IComponentState[] getComponentStates();

    /**
     * Get the IP hostname of the machine hosting the container.
     */
    public String getContainerHost();

    /**
     * Get the time the state value was captured.
     */
    public long getTimeStamp();
}
