/**
 * Copyright 2001-2016 Aurea Software, Inc. All Rights Reserved.
 * 
 * Supports enterprise-aware components by providing a mechanism for IComponent implementations to determine
 * whether the Sonic JMS Messaging infrastructure has enterprise-enabled brokers. The 
 * IEnterpriseStateAccess object provides the ability to determine enterprise state.
 * 
 */

package com.sonicsw.mf.common.runtime;

public interface IEnterpriseAware {
	
	/**
	 * Provide the enterprise aware component ability to determine of whether the messaging infrastructure is
	 * enterprise-enabled.
	 * 
	 * This method is called before the IComponent's init() call. 
	 * @param setting
	 */
	public void setEnterpriseStateAccess(IEnterpriseStateAccess s);

}
