/**
 * Copyright 2001-2016 Aurea Software, Inc. All Rights Reserved.
 * 
 * Mechanism by which enterprise-aware components can determine whether the Sonic JMS Messaging infrastructure
 * has enterprise-enabled brokers. The IEnterpriseStateAccess provides an efficient mechanism for components 
 * to directly access information on the messaging infrastructure enterprise state.
 * 
 */
package com.sonicsw.mf.common.runtime;

public interface IEnterpriseStateAccess {
	/**
	 * Obtains the current enterprise state. IComponents that are designed to operate
	 * independent of a running Sonic Management Server should be prepared for isEnterprise() to return false
	 * until the initial Sonic Management Server connection is made. 
	 * @param setting
	 */
	public boolean isEnterprise();
}
