package com.sonicsw.mf.common.runtime;

/**
 * Indicates the general permissible set of fault tolerant states. If a component exposes additional fault tolerant
 * states then it should extend this interface.
 *
 * Currently used by the Directory service and Agent Manager.
 */
public interface IFaultTolerantState
{
    /** Indicates the component is not fault tolerant. */
    public static final short STATE_NOT_FAULT_TOLERANT  = 0;
    /** Indicates the component is waiting to determine whether it should be transition to an active or standby state. */
    public static final short STATE_WAITING = 1;
    /** Indicates the component is the active component. */
    public static final short STATE_ACTIVE   = 2;
    /** Indicates the component is standing by to become active when the current active component fails. */
    public static final short STATE_STANDBY = 3;

    /** Array container each of the valid fault tolerant states. */
    public static final short[] STATE_VALUES =
        new short[] { 0, 1, 2, 3 };

    /** Textual representations of fault tolerant states (indexed by STATE_<> values). */
    public static final String[] STATE_TEXT =
        new String[] { "Not fault tolerant", "Waiting", "Active", "Standby" };
}
