package com.sonicsw.mf.common.runtime;

import com.sonicsw.mf.common.config.IElementIdentity;

/**
 * A base interface representing the runtime identity of runtime entities.
 *
 * @see IContainerIdentity
 * @see IComponentIdentity
 */
public interface IIdentity
extends Comparable
{
    /** Get the domain name to which the instance belongs. */
    public String getDomainName();

    /** Get the container name within the domain. */
    public String getContainerName();

    /**
     * Gets the full composite name of the instance. The canonical name
     * will vary depending upon the instance implementation, for example:
     * <p>
     * <ul>
     * <li>a containers cananocial name might be: "Sonic.Container"
     * <li>a components cananocial name might be: "Sonic.Container:ID=SonicMQ"
     * </ul>
     */
    public String getCanonicalName();

    /**
     * Gets the configuration identity of the entity (the configuration identity
     * is the location in the Directory Service where this entities configuration
     * is stored).
     */
    public IElementIdentity getConfigIdentity();

    /**
     * Tests if the given object is equal to this identity.
     *
     * @return Returns true if the canonical name and config identity of this identity
     *         equals that of the given object.
     */
    @Override
    public boolean equals(Object object);

    /**
     * Compares this object with the specified object for order. Returns a negative integer,
     * zero, or a positive integer as this object is less than, equal to, or greater than
     * the specified object. Comparison is made using the toString() value.
     *
     * @throws ClassCastException If the given object is not an instance of the same object.
     */
    @Override
    public int compareTo(Object object) throws ClassCastException;
}
