package com.sonicsw.mf.common.runtime;

/**
 * A base interface for interfaces that describe container or component runtime state.
 *
 * @see IContainerState
 * @see IComponentState
 */
public interface IState
extends Comparable
{
    /**
     * Get the runtime identity of the source of the state.
     */
    public IIdentity getRuntimeIdentity();

    /**
     * Get the runtime state value.
     *
     * @return Return either a container or component runtime state value. Possible values
     *         are described in their respective interfaces ("STATE_<>" members).
     *
     * @see IContainerState
     * @see IComponentState
     */
    public short getState();

    /**
     * Get a textual description for the runtime state value.
     *
     * @see IContainerState
     * @see IComponentState
     */
    public String getStateString();

    /**
     * Tests if the given object is equal to this identity.
     *
     * @return Returns true if the runtime identity of this state and its state
     *         equals that of the given object.
     */
    @Override
    public boolean equals(Object object);

    /**
     * Compares this object with the specified object for order. Returns a negative integer,
     * zero, or a positive integer as this object is less than, equal to, or greater than
     * the specified object. Comparison is made using the toString() value.
     *
     * @throws ClassCastException If the given object is not an instance of the same object.
     */
    @Override
    public int compareTo(Object object) throws ClassCastException;

}
