package com.sonicsw.mf.common.runtime;

/**
 * State controllers cause the behavioral change required by a transition from on
 * particular state to another particular state.
 *
 * @see StateManager
 */
public interface IStateController
{
    /**
     * Called by the StateManager when a transition from one state to another is required
     *
     * @return Whether the state transition was succesful or not
     */
    public boolean changeState()
    throws NonRecoverableStateChangeException, RecoverableStateChangeException;
}