package com.sonicsw.mf.common.runtime;

/**
 * State listener methods are called for all state changes. State listeners are registered
 * with a StateManager.
 *
 * @see StateManager
 */
public interface IStateListener
{
    /**
     * Called immediately before a state controller actions a requested state change.
     *
     * @see IStateController
     */
    public void stateChanging(short currentState, short intendedState);

    /**
     * Called immediately after a state controller successfully actions a requested state change.
     *
     * @see IStateController
     */
    public void stateChanged(short previousState, short currentState);

    /**
     * Called immediately before a state controller unsuccessfully actions a requested state change.
     *
     * @see IStateController
     */
    public void stateChangeFailed(short currentState, short intendedState);
}