package com.sonicsw.mf.common.runtime;

/**
 * The implementation of this interface represents the state of a sub component of a MF component.
 *
 * @see IContainerState
 * @see IComponentState
 */
public interface ISubComponentState
extends IState
{
    /** Indicates the sub-component state cannot be determined. */
    public static final short STATE_UNKNOWN  = IComponentState.STATE_UNKNOWN;
    /**
     * Indicates the sub-component is offline (stopped).
     * The sub-component has been created but it is currently not in an
     * operational state.
     */
    public static final short STATE_OFFLINE  = IComponentState.STATE_OFFLINE;
    /** Indicates the sub-component is starting (but not yet operational). */
    public static final short STATE_STARTING = IComponentState.STATE_STARTING;
    /** Indicates the sub-component is online (in operational state). */
    public static final short STATE_ONLINE   = IComponentState.STATE_ONLINE;
    /** Indicates the sub-component is stopping. */
    public static final short STATE_STOPPING = IComponentState.STATE_STOPPING;
    /** Textual representations of sub-component states (indexed by STATE_<> values). */
    public static final String[] STATE_TEXT = IComponentState.STATE_TEXT;
    
    /**
     * Get sub-component identity.
     * <p>
     * The identity is a textual name for the sub-component as known by its parent component. The
     * identity is not globally unique within the Sonic domain and does not in anyway reflect the
     * parent component's JMX ObjectName.
     */
    public String getSubComponentName();
    
    /**
     * Get sub-component type.
     */
    public String getSubComponentType();
}
